/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.ArrayList;
import org.ballerinalang.model.types.ObjectType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BObjectType
extends BStructureType
implements ObjectType {
    private static final String OBJECT = "object";
    private static final String SPACE = " ";
    private static final String DOLLAR = "$";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String LEFT_CURL = "{";
    private static final String RIGHT_CURL = "}";
    private static final String SEMI_COLON = ";";

    public BObjectType(BTypeSymbol tSymbol) {
        super(32, tSymbol);
        this.fields = new ArrayList();
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OBJECT;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        if (this.tsymbol.name.value.startsWith(DOLLAR)) {
            StringBuilder sb = new StringBuilder();
            sb.append(OBJECT).append(SPACE).append(LEFT_CURL);
            for (BField field : this.fields) {
                if (Symbols.isFlagOn(field.symbol.flags, 1)) {
                    sb.append(SPACE).append(PUBLIC);
                } else if (Symbols.isFlagOn(field.symbol.flags, 1024)) {
                    sb.append(SPACE).append(PRIVATE);
                }
                sb.append(SPACE).append(field.type).append(SPACE).append(field.name).append(SEMI_COLON);
            }
            BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)this.tsymbol;
            for (BAttachedFunction fun : objectSymbol.attachedFuncs) {
                if (Symbols.isFlagOn(fun.symbol.flags, 1)) {
                    sb.append(SPACE).append(PUBLIC);
                } else if (Symbols.isFlagOn(fun.symbol.flags, 1024)) {
                    sb.append(SPACE).append(PRIVATE);
                }
                sb.append(SPACE).append(fun).append(SEMI_COLON);
            }
            sb.append(SPACE).append(RIGHT_CURL);
            return sb.toString();
        }
        return this.tsymbol.toString();
    }
}

