/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.model.types.TupleType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BTupleType
extends BType
implements TupleType {
    public List<BType> tupleTypes;
    public BType restType;
    private Optional<Boolean> isAnyData = Optional.empty();

    public BTupleType(List<BType> tupleTypes) {
        super(29, null);
        this.tupleTypes = tupleTypes;
    }

    public BTupleType(BTypeSymbol tsymbol, List<BType> tupleTypes) {
        super(29, tsymbol);
        this.tupleTypes = tupleTypes;
    }

    public List<BType> getTupleTypes() {
        return this.tupleTypes;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TUPLE;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "[" + this.tupleTypes.stream().map(BType::toString).collect(Collectors.joining(",")) + (this.restType != null ? (this.tupleTypes.size() > 0 ? "," : "") + this.restType.toString() + "...]" : "]");
    }

    @Override
    public final boolean isAnydata() {
        if (this.isAnyData.isPresent()) {
            return this.isAnyData.get();
        }
        for (BType memberType : this.tupleTypes) {
            if (memberType.isPureType()) continue;
            this.isAnyData = Optional.of(false);
            return false;
        }
        if (this.restType != null && !this.restType.isPureType()) {
            this.isAnyData = Optional.of(false);
            return false;
        }
        this.isAnyData = Optional.of(true);
        return true;
    }
}

