/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationNode;
import org.ballerinalang.model.tree.CompilationUnitNode;
import org.ballerinalang.model.tree.EndpointNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ImportPackageNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.TypeDefinition;
import org.ballerinalang.model.tree.XMLNSDeclarationNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnostic;

public class BLangPackage
extends BLangNode
implements PackageNode {
    public List<BLangCompilationUnit> compUnits;
    public List<BLangImportPackage> imports;
    public List<BLangXMLNS> xmlnsList;
    public List<BLangEndpoint> globalEndpoints;
    public List<BLangConstant> constants;
    public List<BLangSimpleVariable> globalVars;
    public List<BLangService> services;
    public List<BLangFunction> functions;
    public List<BLangTypeDefinition> typeDefinitions;
    public List<BLangAnnotation> annotations;
    public BLangFunction initFunction;
    public BLangFunction startFunction;
    public BLangFunction stopFunction;
    public Set<CompilerPhase> completedPhases;
    public List<BSymbol> objAttachedFunctions;
    public List<TopLevelNode> topLevelNodes;
    public List<BLangTestablePackage> testablePkgs;
    public Queue<BLangLambdaFunction> lambdaFunctions = new ArrayDeque<BLangLambdaFunction>();
    public PackageID packageID;
    public BPackageSymbol symbol;
    public Set<Flag> flagSet;
    public byte[] jarBinaryContent;
    public BDiagnosticCollector diagCollector;
    public RepoHierarchy repos;

    public BLangPackage() {
        this.compUnits = new ArrayList<BLangCompilationUnit>();
        this.imports = new ArrayList<BLangImportPackage>();
        this.xmlnsList = new ArrayList<BLangXMLNS>();
        this.globalEndpoints = new ArrayList<BLangEndpoint>();
        this.constants = new ArrayList<BLangConstant>();
        this.globalVars = new ArrayList<BLangSimpleVariable>();
        this.services = new ArrayList<BLangService>();
        this.functions = new ArrayList<BLangFunction>();
        this.typeDefinitions = new ArrayList<BLangTypeDefinition>();
        this.annotations = new ArrayList<BLangAnnotation>();
        this.objAttachedFunctions = new ArrayList<BSymbol>();
        this.topLevelNodes = new ArrayList<TopLevelNode>();
        this.completedPhases = EnumSet.noneOf(CompilerPhase.class);
        this.diagCollector = new BDiagnosticCollector();
        this.testablePkgs = new ArrayList<BLangTestablePackage>();
        this.flagSet = EnumSet.noneOf(Flag.class);
    }

    public List<BLangCompilationUnit> getCompilationUnits() {
        return this.compUnits;
    }

    @Override
    public void addCompilationUnit(CompilationUnitNode compUnit) {
        this.compUnits.add((BLangCompilationUnit)compUnit);
    }

    public List<BLangImportPackage> getImports() {
        return this.imports;
    }

    public List<BLangXMLNS> getNamespaceDeclarations() {
        return this.xmlnsList;
    }

    @Override
    public List<? extends EndpointNode> getGlobalEndpoints() {
        return this.globalEndpoints;
    }

    public List<BLangConstant> getConstants() {
        return this.constants;
    }

    public List<BLangSimpleVariable> getGlobalVariables() {
        return this.globalVars;
    }

    public List<BLangService> getServices() {
        return this.services;
    }

    public List<BLangFunction> getFunctions() {
        return this.functions;
    }

    public List<BLangTypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public List<BLangAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addImport(ImportPackageNode importPkg) {
        this.imports.add((BLangImportPackage)importPkg);
    }

    @Override
    public void addNamespaceDeclaration(XMLNSDeclarationNode xmlnsDecl) {
        this.xmlnsList.add((BLangXMLNS)xmlnsDecl);
        this.topLevelNodes.add(xmlnsDecl);
    }

    @Override
    public void addGlobalVariable(SimpleVariableNode globalVar) {
        this.globalVars.add((BLangSimpleVariable)globalVar);
        this.topLevelNodes.add(globalVar);
    }

    @Override
    public void addService(ServiceNode service) {
        this.services.add((BLangService)service);
        this.topLevelNodes.add(service);
    }

    @Override
    public void addFunction(FunctionNode function) {
        this.functions.add((BLangFunction)function);
        this.topLevelNodes.add(function);
    }

    @Override
    public void addAnnotation(AnnotationNode annotation) {
        this.annotations.add((BLangAnnotation)annotation);
        this.topLevelNodes.add(annotation);
    }

    @Override
    public void addTypeDefinition(TypeDefinition typeDefinition) {
        this.typeDefinitions.add((BLangTypeDefinition)typeDefinition);
        this.topLevelNodes.add(typeDefinition);
    }

    public void addTestablePkg(BLangTestablePackage testablePkg) {
        this.testablePkgs.add(testablePkg);
    }

    public List<BLangTestablePackage> getTestablePkgs() {
        return this.testablePkgs;
    }

    public BLangTestablePackage getTestablePkg() {
        return (BLangTestablePackage)this.testablePkgs.stream().findAny().get();
    }

    public boolean containsTestablePkg() {
        return this.testablePkgs.stream().findAny().isPresent();
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.PACKAGE;
    }

    public Set<Flag> getFlags() {
        return this.flagSet;
    }

    public boolean hasTestablePackage() {
        return this.testablePkgs.size() > 0;
    }

    public static class BDiagnosticCollector {
        private int errorCount;
        private List<BDiagnostic> diagnostics = new ArrayList<BDiagnostic>();

        public void addDiagnostic(BDiagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                ++this.errorCount;
            }
            Collections.sort(this.diagnostics);
        }

        public boolean hasErrors() {
            return this.errorCount > 0;
        }
    }
}

