/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.InvocationNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangInvocation
extends BLangAccessExpression
implements InvocationNode {
    public BLangIdentifier pkgAlias;
    public BLangIdentifier name;
    public List<BLangExpression> argExprs = new ArrayList<BLangExpression>();
    public BSymbol exprSymbol;
    public boolean functionPointerInvocation;
    public boolean actionInvocation;
    public boolean langLibInvocation;
    public boolean async;
    public Set<Flag> flagSet;
    public List<BLangAnnotationAttachment> annAttachments = new ArrayList<BLangAnnotationAttachment>();
    public List<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
    public List<BLangExpression> restArgs = new ArrayList<BLangExpression>();

    @Override
    public IdentifierNode getPackageAlias() {
        return this.pkgAlias;
    }

    @Override
    public IdentifierNode getName() {
        return this.name;
    }

    @Override
    public List<? extends ExpressionNode> getArgumentExpressions() {
        return this.argExprs;
    }

    @Override
    public List<? extends ExpressionNode> getRequiredArgs() {
        return this.requiredArgs;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.INVOCATION;
    }

    public String toString() {
        StringBuilder br = new StringBuilder();
        if (this.expr != null) {
            br.append(String.valueOf(this.expr)).append(".");
        } else if (this.pkgAlias != null && !this.pkgAlias.getValue().isEmpty()) {
            br.append(String.valueOf(this.pkgAlias)).append(":");
        }
        br.append(this.name == null ? String.valueOf(this.symbol.name) : String.valueOf(this.name));
        br.append("(");
        if (this.argExprs.size() > 0) {
            String s = Arrays.toString(this.argExprs.toArray());
            br.append(s.substring(1, s.length() - 1));
        }
        br.append(")");
        return br.toString();
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isIterableOperation() {
        return false;
    }

    @Override
    public boolean isActionInvocation() {
        return this.actionInvocation;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public Set<Flag> getFlags() {
        return this.flagSet;
    }

    @Override
    public void addFlag(Flag flag) {
        this.getFlags().add(flag);
    }

    public List<BLangAnnotationAttachment> getAnnotationAttachments() {
        return this.annAttachments;
    }

    @Override
    public void addAnnotationAttachment(AnnotationAttachmentNode annAttachment) {
        this.getAnnotationAttachments().add((BLangAnnotationAttachment)annAttachment);
    }

    public static class BLangActionInvocation
    extends BLangInvocation {
        public BLangActionInvocation(DiagnosticPos pos, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BSymbol symbol, BType type, boolean async) {
            this.pos = pos;
            this.requiredArgs = requiredArgs;
            this.restArgs = restArgs;
            this.symbol = symbol;
            this.type = type;
            this.async = async;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangAttachedFunctionInvocation
    extends BLangInvocation {
        public BLangExpression expr;

        public BLangAttachedFunctionInvocation(DiagnosticPos pos, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BSymbol symbol, BType type, BLangExpression expr, boolean async) {
            this.pos = pos;
            this.requiredArgs = requiredArgs;
            this.restArgs = restArgs;
            this.symbol = symbol;
            this.type = type;
            this.expr = expr;
            this.async = async;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BFunctionPointerInvocation
    extends BLangInvocation {
        public BFunctionPointerInvocation(DiagnosticPos pos, BLangExpression varRef, BSymbol bSymbol, BType retType) {
            this.pos = pos;
            this.expr = varRef;
            this.symbol = bSymbol;
            this.type = retType;
        }

        public BFunctionPointerInvocation(BLangInvocation parent, BLangExpression varRef) {
            this.pos = parent.pos;
            this.name = parent.name;
            this.requiredArgs = parent.requiredArgs;
            this.restArgs = parent.restArgs;
            this.symbol = parent.symbol;
            this.async = parent.async;
            this.expr = varRef;
            this.type = parent.type;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

