/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.TableColumnFlag;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.TableColumnNode;
import org.ballerinalang.model.tree.expressions.TableLiteralNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;

public class BLangTableLiteral
extends BLangExpression
implements TableLiteralNode {
    public List<BLangTableColumn> columns = new ArrayList<BLangTableColumn>();
    public List<BLangExpression> tableDataRows = new ArrayList<BLangExpression>();
    public BLangListConstructorExpr indexColumnsArrayLiteral;
    public BLangListConstructorExpr keyColumnsArrayLiteral;

    public BLangTableColumn getColumn(String columnName) {
        for (BLangTableColumn column : this.columns) {
            if (!column.columnName.equals(columnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public List<? extends ExpressionNode> getDataRows() {
        return this.tableDataRows;
    }

    @Override
    public List<? extends Node> getTableColumns() {
        return this.columns;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.TABLE;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static class BLangTableColumn
    extends BLangNode
    implements TableColumnNode {
        public String columnName;
        public Set<TableColumnFlag> flagSet;

        public BLangTableColumn(String columnName) {
            this.columnName = columnName;
            this.flagSet = EnumSet.noneOf(TableColumnFlag.class);
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.TABLE_COLUMN;
        }

        @Override
        public String getName() {
            return this.columnName;
        }

        @Override
        public Set<TableColumnFlag> getFlagSet() {
            return this.flagSet;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
        }
    }
}

