/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.Whitespace;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangXMLNavigationAccess
extends BLangAccessExpression
implements XMLNavigationAccess {
    public final XMLNavigationAccess.NavAccessType navAccessType;
    public final List<BLangXMLElementFilter> filters;
    public BLangExpression childIndex;
    public boolean methodInvocationAnalyzed;

    public BLangXMLNavigationAccess(DiagnosticPos pos, Set<Whitespace> ws, BLangExpression expr, List<BLangXMLElementFilter> filters, XMLNavigationAccess.NavAccessType navAccessType, BLangExpression childIndex) {
        this.pos = pos;
        this.addWS(ws);
        this.expr = expr;
        this.filters = filters;
        this.navAccessType = navAccessType;
        this.childIndex = childIndex;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.XML_NAVIGATION;
    }

    @Override
    public XMLNavigationAccess.NavAccessType getNavAccessType() {
        return this.navAccessType;
    }

    @Override
    public List<BLangXMLElementFilter> getFilters() {
        return this.filters;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public BLangExpression getChildIndex() {
        return this.childIndex;
    }

    public String toString() {
        switch (this.navAccessType) {
            case CHILDREN: {
                return String.valueOf(this.expr) + "/*";
            }
            case CHILD_ELEMS: {
                StringJoiner filters = new StringJoiner(" |");
                this.filters.forEach(f -> filters.toString());
                return String.valueOf(this.expr) + "/<" + filters.toString() + ">" + (this.childIndex != null ? "[" + String.valueOf(this.childIndex) + "]" : "");
            }
        }
        return null;
    }
}

