/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.statements;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.VariableReferenceNode;
import org.ballerinalang.model.tree.statements.CompoundAssignmentNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangCompoundAssignment
extends BLangStatement
implements CompoundAssignmentNode {
    public BLangVariableReference varRef;
    public BLangExpression expr;
    public OperatorKind opKind;
    public BLangExpression modifiedExpr;

    public BLangCompoundAssignment() {
    }

    public BLangCompoundAssignment(DiagnosticPos pos, BLangVariableReference varRef, BLangExpression expr) {
        this.pos = pos;
        this.varRef = varRef;
        this.expr = expr;
    }

    @Override
    public OperatorKind getOperatorKind() {
        return this.opKind;
    }

    @Override
    public BLangExpression getVariable() {
        return this.varRef;
    }

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public void setExpression(ExpressionNode expression) {
        this.expr = (BLangExpression)expression;
    }

    @Override
    public void setVariable(VariableReferenceNode variableReferenceNode) {
        this.varRef = (BLangVariableReference)variableReferenceNode;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.COMPOUND_ASSIGNMENT;
    }

    public String toString() {
        return "BLangCompoundAssignment: " + (this.varRef != null ? this.varRef : "") + (this.expr != null ? String.valueOf((Object)this.opKind) + "=" + this.expr : "");
    }
}

