/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.ldap.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.net.ssl.SSLContext;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.ldap.CommonLdapConfiguration;
import org.ballerinalang.stdlib.ldap.LdapConnectionContext;
import org.ballerinalang.stdlib.ldap.LdapConstants;
import org.ballerinalang.stdlib.ldap.SslContextTrustManager;
import org.ballerinalang.stdlib.ldap.util.LdapUtils;
import org.ballerinalang.stdlib.ldap.util.SslUtils;

public class InitLdapConnectionContext {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object initLdapConnectionContext(MapValue<?, ?> authProviderConfig, String instanceId) {
        CommonLdapConfiguration commonLdapConfiguration = new CommonLdapConfiguration();
        commonLdapConfiguration.setDomainName(authProviderConfig.getStringValue("domainName"));
        commonLdapConfiguration.setConnectionURL(authProviderConfig.getStringValue("connectionURL"));
        commonLdapConfiguration.setConnectionName(authProviderConfig.getStringValue("connectionName"));
        commonLdapConfiguration.setConnectionPassword(authProviderConfig.getStringValue("connectionPassword"));
        commonLdapConfiguration.setUserSearchBase(authProviderConfig.getStringValue("userSearchBase"));
        commonLdapConfiguration.setUserEntryObjectClass(authProviderConfig.getStringValue("userEntryObjectClass"));
        commonLdapConfiguration.setUserNameAttribute(authProviderConfig.getStringValue("userNameAttribute"));
        commonLdapConfiguration.setUserNameSearchFilter(authProviderConfig.getStringValue("userNameSearchFilter"));
        commonLdapConfiguration.setUserNameListFilter(authProviderConfig.getStringValue("userNameListFilter"));
        commonLdapConfiguration.setGroupSearchBase(InitLdapConnectionContext.getAsStringList(authProviderConfig.getArrayValue("groupSearchBase").getStringArray()));
        commonLdapConfiguration.setGroupEntryObjectClass(authProviderConfig.getStringValue("groupEntryObjectClass"));
        commonLdapConfiguration.setGroupNameAttribute(authProviderConfig.getStringValue("groupNameAttribute"));
        commonLdapConfiguration.setGroupNameSearchFilter(authProviderConfig.getStringValue("groupNameSearchFilter"));
        commonLdapConfiguration.setGroupNameListFilter(authProviderConfig.getStringValue("groupNameListFilter"));
        commonLdapConfiguration.setMembershipAttribute(authProviderConfig.getStringValue("membershipAttribute"));
        commonLdapConfiguration.setUserRolesCacheEnabled(authProviderConfig.getBooleanValue("userRolesCacheEnabled"));
        commonLdapConfiguration.setConnectionPoolingEnabled(authProviderConfig.getBooleanValue("connectionPoolingEnabled"));
        commonLdapConfiguration.setLdapConnectionTimeout(authProviderConfig.getIntValue("connectionTimeoutInMillis").intValue());
        commonLdapConfiguration.setReadTimeoutInMillis(authProviderConfig.getIntValue("readTimeoutInMillis").intValue());
        commonLdapConfiguration.setRetryAttempts(authProviderConfig.getIntValue("retryAttempts").intValue());
        MapValue sslConfig = authProviderConfig.containsKey((Object)"secureSocket") ? authProviderConfig.getMapValue("secureSocket") : null;
        try {
            if (sslConfig != null) {
                InitLdapConnectionContext.setSslConfig(sslConfig, commonLdapConfiguration, instanceId);
                LdapUtils.setServiceName(instanceId);
            }
            LdapConnectionContext connectionSource = new LdapConnectionContext(commonLdapConfiguration);
            DirContext dirContext = connectionSource.getContext();
            MapValue ldapConnectionRecord = BallerinaValues.createRecordValue((BPackage)LdapConstants.LDAP_PACKAGE_ID, (String)"LdapConnection");
            ldapConnectionRecord.addNativeData("ldapConfiguration", (Object)commonLdapConfiguration);
            ldapConnectionRecord.addNativeData("connectionSource", (Object)connectionSource);
            ldapConnectionRecord.addNativeData("connectionContext", (Object)dirContext);
            ldapConnectionRecord.addNativeData("instanceId", (Object)instanceId);
            ldapConnectionRecord.put((Object)"instanceId", (Object)instanceId);
            MapValue mapValue = ldapConnectionRecord;
            return mapValue;
        }
        catch (IOException | IllegalArgumentException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException | NamingException e) {
            if (e.getCause() == null) {
                ErrorValue errorValue = LdapUtils.createError(e.getMessage());
                return errorValue;
            }
            ErrorValue errorValue = LdapUtils.createError(e.getCause().getMessage());
            return errorValue;
        }
        finally {
            if (sslConfig != null) {
                LdapUtils.removeServiceName();
            }
        }
    }

    private static void setSslConfig(MapValue sslConfig, CommonLdapConfiguration commonLdapConfiguration, String instanceId) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, CertificateException {
        String trustCerts;
        MapValue trustStore = sslConfig.getMapValue("trustStore");
        String string = trustCerts = sslConfig.containsKey((Object)"trustedCertFile") ? sslConfig.getStringValue("trustedCertFile") : null;
        if (trustStore != null) {
            String trustStoreFilePath = trustStore.getStringValue("path");
            String trustStorePassword = trustStore.getStringValue("password");
            File trustStoreFile = new File(LdapUtils.substituteVariables(trustStoreFilePath));
            if (!trustStoreFile.exists()) {
                throw new IllegalArgumentException("trustStore File " + trustStoreFilePath + " not found");
            }
            commonLdapConfiguration.setTrustStoreFile(trustStoreFile);
            commonLdapConfiguration.setTrustStorePass(trustStorePassword);
            SSLContext sslContext = SslUtils.createClientSslContext(trustStoreFilePath, trustStorePassword);
            SslContextTrustManager.getInstance().addSSLContext(instanceId, sslContext);
        } else if (trustCerts != null) {
            commonLdapConfiguration.setClientTrustCertificates(trustCerts);
            SSLContext sslContext = SslUtils.getSslContextForCertificateFile(trustCerts);
            SslContextTrustManager.getInstance().addSSLContext(instanceId, sslContext);
        }
    }

    private static List<String> getAsStringList(Object[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Object val : values) {
            valuesList.add(val.toString().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }
}

