/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.ldap.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.ballerinalang.stdlib.ldap.util.LdapUtils;

public class SslUtils {
    public static SSLContext getSslContextForCertificateFile(String filePath) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        KeyStore keyStore = SslUtils.getKeyStore(filePath);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    public static SSLContext createClientSslContext(String trustStoreFilePath, String trustStorePassword) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        File trustStoreFile = new File(LdapUtils.substituteVariables(trustStoreFilePath));
        KeyStore tks = SslUtils.getKeyStore(trustStoreFile, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(tks);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }

    private static KeyStore getKeyStore(String fileName) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore keyStore;
        try (FileInputStream inputStream = new FileInputStream(LdapUtils.substituteVariables(fileName));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate ca = cf.generateCertificate(inputStream);
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", ca);
        }
        return keyStore;
    }

    private static KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore ks = null;
        if (keyStore != null && keyStorePassword != null) {
            try (FileInputStream is = new FileInputStream(keyStore);){
                ks = KeyStore.getInstance("PKCS12");
                ks.load(is, keyStorePassword.toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IOException(e);
            }
        }
        return ks;
    }
}

