/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats;

import io.nats.client.Message;
import java.nio.charset.StandardCharsets;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Constants;

public class Utils {
    public static ErrorValue createNatsError(String nuid, String detailedErrorMessage) {
        MapValue errorDetailRecord = BallerinaValues.createRecordValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"Detail");
        MapValue populatedDetailRecord = BallerinaValues.createRecord((MapValue)errorDetailRecord, (Object[])new Object[]{nuid, detailedErrorMessage});
        return BallerinaErrors.createError((String)"{ballerina/nats}Error", (MapValue)populatedDetailRecord);
    }

    public static ErrorValue createNatsError(String detailedErrorMessage) {
        MapValue errorDetailRecord = BallerinaValues.createRecordValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"Detail");
        errorDetailRecord.put((Object)"message", (Object)detailedErrorMessage);
        return BallerinaErrors.createError((String)"{ballerina/nats}Error", (MapValue)errorDetailRecord);
    }

    public static Object bindDataToIntendedType(byte[] data, BType intendedType) {
        Object dispatchedData;
        int dataParamTypeTag = intendedType.getTag();
        switch (dataParamTypeTag) {
            case 5: {
                dispatchedData = new String(data, StandardCharsets.UTF_8);
                break;
            }
            case 7: {
                try {
                    Object json = JSONParser.parse((String)new String(data, StandardCharsets.UTF_8));
                    dispatchedData = json instanceof String ? StringUtils.fromString((String)((String)json)) : json;
                    break;
                }
                catch (BallerinaException e) {
                    throw Utils.createNatsError("Error occurred in converting message content to json: " + e.getMessage());
                }
            }
            case 1: {
                dispatchedData = Integer.valueOf(new String(data, StandardCharsets.UTF_8));
                break;
            }
            case 6: {
                dispatchedData = Boolean.valueOf(new String(data, StandardCharsets.UTF_8));
                break;
            }
            case 3: {
                dispatchedData = Double.valueOf(new String(data, StandardCharsets.UTF_8));
                break;
            }
            case 4: {
                dispatchedData = new DecimalValue(new String(data, StandardCharsets.UTF_8));
                break;
            }
            case 20: {
                dispatchedData = new ArrayValueImpl(data);
                break;
            }
            case 8: {
                dispatchedData = XMLFactory.parse((String)new String(data, StandardCharsets.UTF_8));
                break;
            }
            case 12: {
                dispatchedData = JSONUtils.convertJSONToRecord((Object)JSONParser.parse((String)new String(data, StandardCharsets.UTF_8)), (BStructureType)((BRecordType)intendedType));
                break;
            }
            default: {
                throw Utils.createNatsError("Unable to find a supported data type to bind the message data");
            }
        }
        return dispatchedData;
    }

    public static ObjectValue getMessageObject(Message message) {
        ObjectValue msgObj;
        if (message != null) {
            ArrayValueImpl msgData = new ArrayValueImpl(message.getData());
            msgObj = BallerinaValues.createObjectValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"Message", (Object[])new Object[]{message.getSubject(), msgData, message.getReplyTo()});
        } else {
            ArrayValueImpl msgData = new ArrayValueImpl(new byte[0]);
            msgObj = BallerinaValues.createObjectValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"Message", (Object[])new Object[]{"", msgData, ""});
        }
        return msgObj;
    }

    public static byte[] convertDataIntoByteArray(Object data) {
        BType dataType = TypeChecker.getType((Object)data);
        int typeTag = dataType.getTag();
        if (typeTag == 5) {
            return ((String)data).getBytes(StandardCharsets.UTF_8);
        }
        return ((ArrayValue)data).getBytes();
    }

    public static AttachedFunction getAttachedFunction(ObjectValue serviceObject, String functionName) {
        AttachedFunction[] resourceFunctions;
        AttachedFunction function = null;
        for (AttachedFunction resourceFunction : resourceFunctions = serviceObject.getType().getAttachedFunctions()) {
            if (!functionName.equals(resourceFunction.getName())) continue;
            function = resourceFunction;
            break;
        }
        return function;
    }

    public static MapValue<String, Object> getSubscriptionConfig(Object annotationData) {
        MapValue annotationRecord = null;
        if (TypeChecker.getType((Object)annotationData).getTag() == 12) {
            annotationRecord = (MapValue)annotationData;
        }
        return annotationRecord;
    }

    public static String getCommaSeparatedUrl(ObjectValue connectionObject) {
        return String.join((CharSequence)", ", connectionObject.getArrayValue("url").getStringArray());
    }
}

