/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic;

import java.util.List;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.nats.AbstractNatsConsumerServiceCompilerPlugin;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="nats", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="nats", name="Message")})
public class NatsBasicConsumerServiceCompilerPlugin
extends AbstractNatsConsumerServiceCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    @Override
    public void validateAnnotationPresence(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        if (annotations.stream().noneMatch(annotation -> annotation.getAnnotationName().getValue().equals("SubscriptionConfig"))) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), "nats:SubscriptionConfig annotation is required to be declared in the consumer service");
        }
    }

    @Override
    public void logDiagnostic(Diagnostic.Kind diagnosticKind, Diagnostic.DiagnosticPosition diagnosticPosition, String errorMessage) {
        this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, diagnosticPosition, (CharSequence)errorMessage);
    }

    @Override
    public void validateMessageParameter(BLangSimpleVariable firstParameter, BLangFunction resourceFunction, String errorMessage) {
        BType firstParamType = firstParameter.getTypeNode().type;
        if (firstParamType.tag != 32) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
        } else {
            BObjectType objectType = (BObjectType)firstParamType;
            if (!objectType.tsymbol.getName().getValue().equals("Message")) {
                this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
            }
        }
    }

    @Override
    public String getInvalidMessageResourceSignatureErrorMessage(ServiceNode serviceNode, BLangFunction resourceFunction) {
        String errorMessage = "Invalid resource signature for the %s resource function in %s service. Expected first parameter (required) type is nats:Message and the expected second parameter (optional) type is byte[] | boolean | string | int | float | decimal | xml | json | record {}";
        return String.format(errorMessage, resourceFunction.getName().getValue(), serviceNode.getName().getValue());
    }

    @Override
    public String getInvalidErrorResourceSignatureErrorMessage(ServiceNode serviceNode, BLangFunction resourceFunction) {
        String errorMessage = "Invalid resource signature for the %s resource function in %s service. Expected first parameter (required) type is nats:Message and the expected second parameter (required) type is error";
        return String.format(errorMessage, resourceFunction.getName().getValue(), serviceNode.getName().getValue());
    }
}

