/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming;

import java.util.List;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.nats.AbstractNatsConsumerServiceCompilerPlugin;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="nats", name="StreamingListener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="nats", name="StreamingMessage")})
public class NatsStreamingSubscriberServiceCompilerPlugin
extends AbstractNatsConsumerServiceCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    @Override
    public void validateAnnotationPresence(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        if (annotations.stream().noneMatch(annotation -> annotation.getAnnotationName().getValue().equals("StreamingSubscriptionConfig"))) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), "nats:StreamingSubscriptionConfig annotation is required to be declared in the subscription service");
        }
    }

    @Override
    public void validateMessageParameter(BLangSimpleVariable firstParameter, BLangFunction resourceFunction, String errorMessage) {
        BType firstParamType = firstParameter.getTypeNode().type;
        if (firstParamType.tag != 32) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
        } else {
            BObjectType objectType = (BObjectType)firstParamType;
            if (!objectType.tsymbol.getName().getValue().equals("StreamingMessage")) {
                this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
            }
        }
    }

    @Override
    public String getInvalidMessageResourceSignatureErrorMessage(ServiceNode serviceNode, BLangFunction resourceFunction) {
        String errorMessage = "Invalid resource signature for the %s resource function in %s service. Expected first parameter (required) type is nats:StreamingMessage and the expected second paramter (optional) type is byte[] | boolean | string | int | float | decimal | xml | json | record {}";
        return String.format(errorMessage, resourceFunction.getName().getValue(), serviceNode.getName().getValue());
    }

    @Override
    public String getInvalidErrorResourceSignatureErrorMessage(ServiceNode serviceNode, BLangFunction resourceFunction) {
        String errorMessage = "Invalid resource signature for the %s resource function in %s service. Expected first parameter (required) type is nats:StreamingMessage and the expected second paramter (required) type is error";
        return String.format(errorMessage, resourceFunction.getName().getValue(), serviceNode.getName().getValue());
    }

    @Override
    public void logDiagnostic(Diagnostic.Kind diagnosticKind, Diagnostic.DiagnosticPosition diagnosticPosition, String errorMessage) {
        this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, diagnosticPosition, (CharSequence)errorMessage);
    }
}

