/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.packerina.TaskExecutor;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.packerina.task.CompileTask;
import org.ballerinalang.packerina.task.CreateDocsTask;
import org.ballerinalang.packerina.task.CreateTargetDirTask;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="doc", description={"Ballerina doc - Generates API Documentation"})
public class DocCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    private Path jsonPath;
    @CommandLine.Option(names={"--sourceroot"}, description={"Path to the directory containing source files and modules."})
    private String sourceRoot;
    @CommandLine.Option(names={"--all", "-a"}, description={"Generate docs for all the modules of the project."})
    private boolean buildAll;
    @CommandLine.Option(names={"--toJSON", "-toJSON"}, description={"Generate JSON containing doc data."})
    private boolean toJson;
    @CommandLine.Option(names={"--fromJSON", "-fromJSON"}, description={"Generate API Docs from a JSON."})
    private String jsonLoc;
    @CommandLine.Option(names={"--o", "-o"}, description={"Location to save API Docs."})
    private String outputLoc;
    @CommandLine.Option(names={"--excludeIndex", "-excludeIndex"}, description={"Prevents project index from being generated."})
    private boolean excludeIndex;
    @CommandLine.Option(names={"--offline"}, description={"Compiles offline without downloading dependencies."})
    private boolean offline;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--exclude", "-e"}, description={"List of modules to be excluded."})
    private String[] excludes;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;

    public DocCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public void execute() {
        Path targetPath;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"doc");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina doc [--sourceroot] [--offline]\n                     {<module-name> | -a | --all}", false);
            CommandUtil.exitError(true);
            return;
        }
        Path sourcePath = null;
        Path path = this.sourceRootPath = null != this.sourceRoot ? Paths.get(this.sourceRoot, new String[0]).toAbsolutePath() : this.sourceRootPath;
        if (this.jsonLoc != null) {
            this.jsonPath = Paths.get(this.jsonLoc, new String[0]).toAbsolutePath();
            if (Files.notExists(this.jsonPath, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "cannot find json file", null, false);
                CommandUtil.exitError(true);
                return;
            }
            targetPath = null != this.outputLoc ? Paths.get(this.outputLoc, new String[0]).toAbsolutePath() : this.sourceRootPath.resolve("target");
            BuildContext buildContext = new BuildContext(this.sourceRootPath, targetPath, null);
            buildContext.setOut(this.outStream);
            buildContext.setErr(this.errStream);
            TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CreateTargetDirTask()).addTask(new CreateDocsTask(this.toJson, this.jsonPath, this.excludeIndex)).build();
            taskExecutor.executeTasks(buildContext);
            Runtime.getRuntime().exit(0);
        } else {
            this.jsonPath = null;
        }
        if (!(this.buildAll || this.argList != null && this.argList.size() != 0)) {
            CommandUtil.printError(this.errStream, "'doc' command requires a module name. use '-a' or '--all' flag to generate api documentation for all the modules of the project.", "ballerina doc {<module-name> | -a | --all}", false);
            CommandUtil.exitError(true);
            return;
        }
        if (this.buildAll) {
            if (!ProjectDirs.isProject((Path)this.sourceRootPath)) {
                Path findRoot = ProjectDirs.findProjectRoot((Path)this.sourceRootPath);
                if (null == findRoot) {
                    CommandUtil.printError(this.errStream, "you are not in a Ballerina project.", null, false);
                    CommandUtil.exitError(true);
                    return;
                }
                this.sourceRootPath = findRoot;
            }
            targetPath = this.sourceRootPath.resolve("target");
        } else {
            if (this.argList.get(0).endsWith(".bal")) {
                CommandUtil.printError(this.errStream, "generating API Documentation is not supported for a single Ballerina file.", null, false);
                CommandUtil.exitError(true);
                return;
            }
            if (Files.exists(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0]) && Files.isDirectory(this.sourceRootPath.resolve("src").resolve(this.argList.get(0)), new LinkOption[0])) {
                if (!RepoUtils.isBallerinaProject((Path)this.sourceRootPath)) {
                    CommandUtil.printError(this.errStream, "you are trying to generate docs for a module that is not inside a project.", null, false);
                    CommandUtil.exitError(true);
                    return;
                }
                if (Paths.get(this.argList.get(0), new String[0]).isAbsolute()) {
                    CommandUtil.printError(this.errStream, "you are trying to generate docs for a module by giving the absolute path. you only need give the name of the module.", "ballerina doc <module-name>", true);
                    CommandUtil.exitError(true);
                    return;
                }
                String moduleName = this.argList.get(0);
                if (moduleName.endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 1);
                }
                sourcePath = Paths.get(moduleName, new String[0]);
                if (Files.notExists(this.sourceRootPath.resolve("src").resolve(sourcePath), new LinkOption[0])) {
                    CommandUtil.printError(this.errStream, "'" + sourcePath + "' module does not exist.", "ballerina doc <module-name>", true);
                    CommandUtil.exitError(true);
                    return;
                }
                targetPath = this.sourceRootPath.resolve("target");
            } else {
                CommandUtil.printError(this.errStream, "invalid Ballerina source path. It should be a name of a module in a Ballerina project. Use the -a or --all flag to generate docs for all modules.", "ballerina doc {<module-name> | -a | --all}", true);
                CommandUtil.exitError(true);
                return;
            }
        }
        this.sourceRootPath = this.sourceRootPath.normalize();
        sourcePath = sourcePath == null ? null : sourcePath.normalize();
        targetPath = targetPath.normalize();
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
        options.put(CompilerOptionName.PROJECT_DIR, this.sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(this.offline));
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_ANALYZE.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(true));
        options.put(CompilerOptionName.TEST_ENABLED, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(this.experimentalFlag));
        BuildContext buildContext = new BuildContext(this.sourceRootPath, targetPath, sourcePath, compilerContext);
        buildContext.setOut(this.outStream);
        buildContext.setErr(this.errStream);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CreateTargetDirTask()).addTask(new CompileTask()).addTask(new CreateDocsTask(this.toJson, this.jsonPath, this.excludeIndex)).build();
        taskExecutor.executeTasks(buildContext);
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "doc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates API Documentation for Ballerina module(s)/file. \n");
        out.append("\n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina doc {<ballerina-file | module-name> | -a | --all} \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

