/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.ballerinalang.packerina.cmd.CommandUtil;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="new", description={"Create a new Ballerina project"})
public class NewCommand
implements BLauncherCmd {
    private Path userDir;
    private PrintStream errStream;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public NewCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
    }

    public NewCommand(Path userDir, PrintStream errStream) {
        this.userDir = userDir;
        this.errStream = errStream;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"new");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (null == this.argList) {
            CommandUtil.printError(this.errStream, "The following required arguments were not provided:\n    <project-name>", "ballerina new <project-name>", true);
            return;
        }
        if (1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina new <project-name>", true);
            return;
        }
        Path path = this.userDir.resolve(this.argList.get(0));
        if (Files.exists(path, new LinkOption[0])) {
            CommandUtil.printError(this.errStream, "destination '" + path.toString() + "' already exists", "ballerina new <project-name>", true);
            return;
        }
        Path projectRoot = ProjectDirs.findProjectRoot((Path)path);
        if (projectRoot != null) {
            CommandUtil.printError(this.errStream, "Directory is already within a Ballerina project :" + projectRoot.toString(), null, false);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            CommandUtil.initProject(path);
        }
        catch (AccessDeniedException e) {
            this.errStream.println("error: Error occurred while creating project : Insufficient Permission");
        }
        catch (IOException e) {
            this.errStream.println("error: Error occurred while creating project : " + e.getMessage());
            return;
        }
        this.errStream.println("Created new Ballerina project at " + this.userDir.relativize(path));
        this.errStream.println();
        this.errStream.println("Next:");
        this.errStream.println("    Move into the project directory and use `ballerina add <module-name>` to");
        this.errStream.println("    add a new Ballerina module.");
    }

    public String getName() {
        return "new";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("create a new Ballerina project");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina new <project-name> \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

