/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.model.ExecutableJar;
import org.ballerinalang.packerina.task.Task;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;

public class CopyModuleJarTask
implements Task {
    private boolean skipCopyLibsFromDist;
    private boolean skipTests;

    public CopyModuleJarTask(boolean skipCopyLibsFromDist, boolean skipTests) {
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.skipTests = skipTests;
    }

    @Override
    public void execute(BuildContext buildContext) {
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        String balHomePath = buildContext.get(BuildContextField.HOME_REPO).toString();
        List<BLangPackage> moduleBirMap = buildContext.getModules();
        this.copyImportedJars(buildContext, moduleBirMap, sourceRootPath, balHomePath);
    }

    private void copyImportedJars(BuildContext buildContext, List<BLangPackage> moduleBirMap, Path sourceRootPath, String balHomePath) {
        HashMap<PackageID, Path> alreadyImportedMap = new HashMap<PackageID, Path>();
        for (BLangPackage pkg : moduleBirMap) {
            ExecutableJar executableJar = buildContext.moduleDependencyPathMap.get(pkg.packageID);
            this.copyImportedJars(pkg.symbol.imports, buildContext, sourceRootPath, balHomePath, executableJar.moduleLibs, alreadyImportedMap);
            if (this.skipTests || !pkg.hasTestablePackage()) continue;
            for (BLangPackage testPkg : pkg.getTestablePkgs()) {
                this.copyImportedJars(testPkg.symbol.imports, buildContext, sourceRootPath, balHomePath, executableJar.testLibs, alreadyImportedMap);
            }
        }
    }

    private void copyImportedJars(List<BPackageSymbol> imports, BuildContext buildContext, Path sourceRootPath, String balHomePath, HashSet<Path> moduleDependencyList, Map<PackageID, Path> alreadyImportedMap) {
        for (BPackageSymbol importSymbol : imports) {
            PackageID pkgId = importSymbol.pkgID;
            Path importedPath = alreadyImportedMap.get(pkgId);
            if (importedPath != null) {
                moduleDependencyList.add(importedPath);
            } else {
                this.copyImportedJar(buildContext, importSymbol, sourceRootPath, balHomePath, moduleDependencyList, alreadyImportedMap);
            }
            this.copyImportedJars(importSymbol.imports, buildContext, sourceRootPath, balHomePath, moduleDependencyList, alreadyImportedMap);
        }
    }

    private void copyImportedJar(BuildContext buildContext, BPackageSymbol importz, Path project, String balHomePath, HashSet<Path> moduleDependencyList, Map<PackageID, Path> alreadyImportedMap) {
        PackageID id = importz.pkgID;
        String moduleJarName = id.orgName.value + "-" + id.name.value + "-" + id.version.value + ".jar";
        Path importJar = ProjectDirs.isModuleExist((Path)project, (String)id.name.value) || buildContext.getImportPathDependency(id).isPresent() ? buildContext.getJarPathFromTargetCache(id) : buildContext.getJarPathFromHomeCache(id);
        if (importJar == null || !Files.exists(importJar, new LinkOption[0])) {
            if (this.skipCopyLibsFromDist) {
                return;
            }
            importJar = Paths.get(balHomePath, "bre", "lib", moduleJarName);
            if (Files.notExists(importJar, new LinkOption[0])) {
                importJar = Paths.get(balHomePath, "bre", "lib", id.orgName.value + "." + id.name.value + ".jar");
            }
        }
        moduleDependencyList.add(importJar);
        alreadyImportedMap.put(importz.pkgID, importJar);
    }
}

