/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import java.io.File;
import org.ballerinalang.maven.Dependency;
import org.ballerinalang.maven.MavenResolver;
import org.ballerinalang.maven.Utils;
import org.ballerinalang.maven.exceptions.MavenResolverException;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.toml.model.Library;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ResolveMavenDependenciesTask
implements Task {
    @Override
    public void execute(BuildContext buildContext) {
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        Manifest manifest = ManifestProcessor.getInstance((CompilerContext)context).getManifest();
        if (manifest.getPlatform().getLibraries() == null) {
            return;
        }
        String targetRepo = buildContext.get(BuildContextField.TARGET_DIR).toString() + File.separator + "platform-libs";
        MavenResolver resolver = new MavenResolver(targetRepo);
        buildContext.out().println();
        for (Library library : manifest.getPlatform().getLibraries()) {
            if (library.getPath() != null) continue;
            buildContext.out().println("Resolving " + library.getArtifactId());
            try {
                Dependency dependency = resolver.resolve(library.getGroupId(), library.getArtifactId(), library.getVersion(), false);
                library.setPath(Utils.getJarPath((String)targetRepo, (Dependency)dependency));
            }
            catch (MavenResolverException e) {
                buildContext.err().print("cannot resolve " + library.getArtifactId());
            }
        }
    }
}

