/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.task;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.packerina.OsUtils;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.buildcontext.sourcecontext.SingleFileContext;
import org.ballerinalang.packerina.model.ExecutableJar;
import org.ballerinalang.packerina.task.Task;
import org.ballerinalang.packerina.utils.DebugUtils;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.util.CodeCoverageUtils;
import org.ballerinalang.test.runtime.util.TesterinaUtils;
import org.ballerinalang.testerina.core.TesterinaRegistry;
import org.ballerinalang.tool.LauncherUtils;
import org.ballerinalang.tool.util.BFileUtil;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.util.Lists;
import org.wso2.ballerinalang.util.RepoUtils;

public class RunTestsTask
implements Task {
    private final String[] args;
    private boolean report;
    private boolean coverage;
    private boolean isSingleTestExecution;
    private List<String> singleExecTests;
    private Path testJarPath;
    TestReport testReport;
    private final String includesInCoverage;

    public RunTestsTask(boolean report, boolean coverage, String[] args, String includes) {
        this.coverage = coverage;
        this.args = args;
        this.report = report;
        if (report || coverage) {
            this.testReport = new TestReport();
        }
        this.includesInCoverage = includes;
    }

    public RunTestsTask(boolean report, boolean coverage, String[] args, List<String> groupList, List<String> disableGroupList, List<String> testList, String includes) {
        this.args = args;
        this.report = report;
        this.coverage = coverage;
        this.isSingleTestExecution = false;
        TesterinaRegistry testerinaRegistry = TesterinaRegistry.getInstance();
        if (disableGroupList != null) {
            testerinaRegistry.setGroups(disableGroupList);
            testerinaRegistry.setShouldIncludeGroups(false);
        } else if (groupList != null) {
            testerinaRegistry.setGroups(groupList);
            testerinaRegistry.setShouldIncludeGroups(true);
        } else if (testList != null) {
            this.isSingleTestExecution = true;
            this.singleExecTests = testList;
        }
        if (report || coverage) {
            this.testReport = new TestReport();
        }
        this.includesInCoverage = includes;
    }

    @Override
    public void execute(BuildContext buildContext) {
        Path targetDir = Paths.get(buildContext.get(BuildContextField.TARGET_DIR).toString(), new String[0]);
        buildContext.out().println();
        buildContext.out().print("Running Tests");
        if (this.coverage) {
            buildContext.out().print(" with Coverage");
            try {
                CodeCoverageUtils.deleteDirectory((File)targetDir.resolve("coverage").toFile());
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error while cleaning up coverage data", (Throwable)e);
            }
        }
        buildContext.out().println();
        Path sourceRootPath = (Path)buildContext.get(BuildContextField.SOURCE_ROOT);
        List<BLangPackage> moduleBirMap = buildContext.getModules();
        int result = 0;
        for (BLangPackage bLangPackage : moduleBirMap) {
            TestSuite suite = (TestSuite)TesterinaRegistry.getInstance().getTestSuites().get(bLangPackage.packageID.toString());
            if (this.isSingleTestExecution) {
                suite.setTests(TesterinaUtils.getSingleExecutionTests((List)suite.getTests(), this.singleExecTests));
            }
            if (suite == null) {
                if (!".".equals(bLangPackage.packageID.toString())) {
                    buildContext.out().println();
                    buildContext.out().println("\t" + bLangPackage.packageID);
                }
                buildContext.out().println("\tNo tests found");
                buildContext.out().println();
                continue;
            }
            if (this.isSingleTestExecution && suite.getTests().size() == 0) {
                buildContext.out().println("\tNo tests found with the given name/s");
                buildContext.out().println();
                continue;
            }
            suite.setReportRequired(this.report || this.coverage);
            HashSet<Path> testDependencies = this.getTestDependencies(buildContext, bLangPackage);
            Path jsonPath = buildContext.getTestJsonPathTargetCache(bLangPackage.packageID);
            RunTestsTask.createTestJson(bLangPackage, suite, sourceRootPath, jsonPath);
            int testResult = this.runTestSuit(jsonPath, buildContext, testDependencies, bLangPackage);
            if (result == 0) {
                result = testResult;
            }
            if (this.report || this.coverage) {
                String projectName;
                if (buildContext.get(BuildContextField.SOURCE_CONTEXT) instanceof SingleFileContext) {
                    SingleFileContext singleFileContext = (SingleFileContext)buildContext.get(BuildContextField.SOURCE_CONTEXT);
                    projectName = singleFileContext.getBalFile().toFile().getName();
                } else {
                    projectName = sourceRootPath.toFile().getName();
                }
                this.testReport.setProjectName(projectName);
                Path statusJsonPath = jsonPath.resolve("module_status.json");
                try {
                    ModuleStatus moduleStatus = this.loadModuleStatusFromFile(statusJsonPath);
                    this.testReport.addModuleStatus(String.valueOf(bLangPackage.packageID.name), moduleStatus);
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException((String)"error while generating test report", (Throwable)e);
                }
            }
            if (!this.coverage) continue;
            int coverageResult = this.generateCoverageReport(buildContext, testDependencies, bLangPackage);
            if (coverageResult != 0) {
                throw LauncherUtils.createLauncherException((String)"error while generating test report");
            }
            Path coverageJsonPath = jsonPath.resolve("module_coverage.json");
            try {
                ModuleCoverage moduleCoverage = this.loadModuleCoverageFromFile(coverageJsonPath);
                this.testReport.addCoverage(String.valueOf(bLangPackage.packageID.name), moduleCoverage);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error while generating test report", (Throwable)e);
            }
        }
        if ((this.report || this.coverage) && this.testReport.getModuleStatus().size() > 0) {
            this.testReport.finalizeTestResults(this.coverage);
            this.generateHtmlReport(buildContext.out(), this.testReport, targetDir);
        }
        if (result != 0) {
            throw LauncherUtils.createLauncherException((String)"there are test failures");
        }
    }

    private static void createTestJson(BLangPackage bLangPackage, TestSuite suite, Path sourceRootPath, Path jsonPath) {
        suite.setInitFunctionName(bLangPackage.initFunction.name.value);
        suite.setStartFunctionName(bLangPackage.startFunction.name.value);
        suite.setStopFunctionName(bLangPackage.stopFunction.name.value);
        suite.setPackageName(bLangPackage.packageID.toString());
        suite.setSourceRootPath(sourceRootPath.toString());
        bLangPackage.functions.forEach(function -> {
            String functionClassName = BFileUtil.getQualifiedClassName((String)bLangPackage.packageID.orgName.value, (String)bLangPackage.packageID.name.value, (String)RunTestsTask.getClassName(function.pos.src.cUnitName));
            suite.addTestUtilityFunction(function.name.value, functionClassName);
        });
        if (bLangPackage.containsTestablePkg()) {
            suite.setTestInitFunctionName(bLangPackage.getTestablePkg().initFunction.name.value);
            suite.setTestStartFunctionName(bLangPackage.getTestablePkg().startFunction.name.value);
            suite.setTestStopFunctionName(bLangPackage.getTestablePkg().stopFunction.name.value);
            bLangPackage.getTestablePkg().functions.forEach(function -> {
                String functionClassName = BFileUtil.getQualifiedClassName((String)bLangPackage.packageID.orgName.value, (String)bLangPackage.packageID.name.value, (String)RunTestsTask.getClassName(function.pos.src.cUnitName));
                suite.addTestUtilityFunction(function.name.value, functionClassName);
            });
        } else {
            suite.setSourceFileName(bLangPackage.packageID.sourceFileName.value);
        }
        RunTestsTask.writeToJson(suite, jsonPath);
    }

    private static String getClassName(String function) {
        return function.replace(".bal", "").replace("/", ".");
    }

    private static void writeToJson(TestSuite testSuite, Path jsonPath) {
        Path tmpJsonPath = Paths.get(jsonPath.toString(), "test_suit.json");
        File jsonFile = new File(tmpJsonPath.toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            String json = gson.toJson((Object)testSuite);
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("couldn't read data from the Json file : " + e.toString()));
        }
    }

    private void generateHtmlReport(PrintStream out, TestReport testReport, Path jsonPath) {
        String content;
        out.println();
        out.println("Generating Test Report");
        Gson gson = new Gson();
        String json = gson.toJson((Object)testReport).replaceAll("\\\\\\(", "(");
        File jsonFile = new File(jsonPath.resolve("test_results.json").toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            out.println("\t" + Paths.get("", new String[0]).toAbsolutePath().relativize(jsonFile.toPath()) + "\n");
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("couldn't read data from the Json file : " + e.toString()));
        }
        try {
            CodeCoverageUtils.unzipReportResources((InputStream)this.getClass().getClassLoader().getResourceAsStream("report.zip"), (File)jsonPath.resolve("report").toFile());
            content = new String(Files.readAllBytes(jsonPath.resolve("report").resolve("index.html")), StandardCharsets.UTF_8);
            content = content.replace("__data__", json);
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("error occurred while preparing test report: " + e.toString()));
        }
        File htmlFile = new File(jsonPath.resolve("report").resolve("index.html").toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), StandardCharsets.UTF_8);){
            writer.write(new String(content.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            out.println("\tView the test report at: file://" + htmlFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("couldn't read data from the Json file : " + e.toString()));
        }
    }

    private int runTestSuit(Path jsonPath, BuildContext buildContext, HashSet<Path> testDependencies, BLangPackage bLangPackage) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(System.getProperty("java.command"));
        String mainClassName = "org.ballerinalang.test.runtime.Main";
        Path targetDir = Paths.get(buildContext.get(BuildContextField.TARGET_DIR).toString(), new String[0]);
        String orgName = String.valueOf(bLangPackage.packageID.orgName);
        String packageName = String.valueOf(bLangPackage.packageID.name);
        String jacocoAgentJarPath = Paths.get(System.getProperty("ballerina.home"), new String[0]).resolve("bre").resolve("lib").resolve("jacocoagent.jar").toString();
        try {
            if (this.coverage) {
                String agentCommand = "-javaagent:" + jacocoAgentJarPath + "=destfile=" + targetDir.resolve("coverage").resolve("ballerina.exec").toString();
                agentCommand = !".".equals(packageName) && this.includesInCoverage == null ? agentCommand + ",includes=" + orgName + "." + packageName + ".*" : agentCommand + ",includes=" + this.includesInCoverage;
                cmdArgs.add(agentCommand);
            }
            String classPath = this.getClassPath(this.getTestRuntimeJar(buildContext), testDependencies);
            cmdArgs.addAll(Lists.of((Object[])new String[]{"-cp", classPath}));
            if (DebugUtils.isInDebugMode()) {
                cmdArgs.add(DebugUtils.getDebugArgs(buildContext));
            }
            cmdArgs.add(mainClassName);
            cmdArgs.add(jsonPath.toString());
            cmdArgs.addAll(Arrays.asList(this.args));
            cmdArgs.add(targetDir.toString());
            cmdArgs.add(this.testJarPath.toString());
            cmdArgs.add(orgName);
            cmdArgs.add(packageName);
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs).inheritIO();
            Process proc = processBuilder.start();
            return proc.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw LauncherUtils.createLauncherException((String)("unable to run the tests: " + e.getMessage()));
        }
    }

    private int generateCoverageReport(BuildContext buildContext, HashSet<Path> testDependencies, BLangPackage bLangPackage) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(System.getProperty("java.command"));
        String mainClassName = "org.ballerinalang.test.runtime.CoverageMain";
        Path jsonPath = buildContext.getTestJsonPathTargetCache(bLangPackage.packageID);
        Path targetDir = Paths.get(buildContext.get(BuildContextField.TARGET_DIR).toString(), new String[0]);
        String orgName = String.valueOf(bLangPackage.packageID.orgName);
        String packageName = String.valueOf(bLangPackage.packageID.name);
        try {
            String classPath = this.getClassPath(this.getTestRuntimeJar(buildContext), testDependencies);
            cmdArgs.addAll(Lists.of((Object[])new String[]{"-cp", classPath, mainClassName, jsonPath.toString()}));
            cmdArgs.add(targetDir.toString());
            cmdArgs.add(this.testJarPath.toString());
            cmdArgs.add(orgName);
            cmdArgs.add(packageName);
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs).inheritIO();
            Process proc = processBuilder.start();
            return proc.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw LauncherUtils.createLauncherException((String)("unable to run the tests: " + e.getMessage()));
        }
    }

    private HashSet<Path> getTestDependencies(BuildContext buildContext, BLangPackage bLangPackage) {
        this.testJarPath = bLangPackage.containsTestablePkg() ? buildContext.getTestJarPathFromTargetCache(bLangPackage.packageID) : buildContext.getJarPathFromTargetCache(bLangPackage.packageID);
        ExecutableJar executableJar = buildContext.moduleDependencyPathMap.get(bLangPackage.packageID);
        HashSet<Path> testDependencies = new HashSet<Path>(executableJar.moduleLibs);
        testDependencies.addAll(executableJar.testLibs);
        testDependencies.add(this.testJarPath);
        return testDependencies;
    }

    private String getClassPath(Path testRuntimeJar, HashSet<Path> testDependencies) {
        String separator = ":";
        StringBuilder classPath = new StringBuilder();
        classPath.append(testRuntimeJar);
        if (OsUtils.isWindows()) {
            separator = ";";
        }
        for (Path testDependency : testDependencies) {
            classPath.append(separator).append(testDependency);
        }
        return classPath.toString();
    }

    private Path getTestRuntimeJar(BuildContext buildContext) {
        String balHomePath = buildContext.get(BuildContextField.HOME_REPO).toString();
        String ballerinaVersion = RepoUtils.getBallerinaVersion();
        String runtimeJarName = "testerina-runtime-" + ballerinaVersion + ".jar";
        return Paths.get(balHomePath, "bre", "lib", runtimeJarName);
    }

    private ModuleCoverage loadModuleCoverageFromFile(Path coverageJsonPath) throws IOException {
        Gson gson = new Gson();
        BufferedReader bufferedReader = Files.newBufferedReader(coverageJsonPath, StandardCharsets.UTF_8);
        return (ModuleCoverage)gson.fromJson((Reader)bufferedReader, ModuleCoverage.class);
    }

    private ModuleStatus loadModuleStatusFromFile(Path statusJsonPath) throws IOException {
        Gson gson = new Gson();
        BufferedReader bufferedReader = Files.newBufferedReader(statusJsonPath, StandardCharsets.UTF_8);
        return (ModuleStatus)gson.fromJson((Reader)bufferedReader, ModuleStatus.class);
    }
}

