/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.utils;

import org.ballerinalang.packerina.buildcontext.BuildContext;

public class DebugUtils {
    private static final String DEBUG_ARGS_JAVA8 = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y";
    private static final String JAVA_VERSION_PROP = "java.version";
    private static final String COMPATIBLE_JRE_VERSION = "1.8";

    public static boolean isInDebugMode() {
        return System.getProperty("debug") != null && !System.getProperty("debug").isEmpty();
    }

    public static String getDebugArgs(BuildContext context) {
        String javaVersion = System.getProperty(JAVA_VERSION_PROP);
        if (javaVersion != null && !javaVersion.startsWith(COMPATIBLE_JRE_VERSION)) {
            context.err().printf("WARNING: Incompatible JRE version '%s' found. Ballerina program debugging supports on JRE version '%s'%n", javaVersion, COMPATIBLE_JRE_VERSION);
        }
        return String.format("%s,address=%s", DEBUG_ARGS_JAVA8, System.getProperty("debug"));
    }
}

