/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.packerina.writer;

import com.moandjiezana.toml.TomlWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.packerina.buildcontext.BuildContext;
import org.ballerinalang.packerina.buildcontext.BuildContextField;
import org.ballerinalang.packerina.model.BaloToml;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.DependencyMetadata;
import org.ballerinalang.toml.model.Library;
import org.ballerinalang.toml.model.LockFile;
import org.ballerinalang.toml.model.LockFileImport;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Module;
import org.ballerinalang.toml.model.Platform;
import org.ballerinalang.toml.parser.LockFileProcessor;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.RepoUtils;

public class BaloFileWriter {
    private static final CompilerContext.Key<BaloFileWriter> MODULE_FILE_WRITER_KEY = new CompilerContext.Key();
    private final SourceDirectory sourceDirectory;
    private final Manifest manifest;
    private final BuildContext buildContext;

    public static BaloFileWriter getInstance(BuildContext buildContext) {
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        BaloFileWriter baloFileWriter = (BaloFileWriter)context.get(MODULE_FILE_WRITER_KEY);
        if (baloFileWriter == null) {
            baloFileWriter = new BaloFileWriter(buildContext);
        }
        return baloFileWriter;
    }

    private BaloFileWriter(BuildContext buildContext) {
        CompilerContext context = (CompilerContext)buildContext.get(BuildContextField.COMPILER_CONTEXT);
        context.put(MODULE_FILE_WRITER_KEY, (Object)this);
        this.buildContext = buildContext;
        this.sourceDirectory = (SourceDirectory)context.get(SourceDirectory.class);
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
        this.manifest = ManifestProcessor.getInstance((CompilerContext)context).getManifest();
    }

    public void write(BLangPackage module, Path baloFilePath, HashSet<Path> moduleDependencyList) {
        String moduleName;
        Path projectDirectory = this.sourceDirectory.getPath();
        if (!ProjectDirs.isModuleExist((Path)projectDirectory, (String)(moduleName = module.packageID.name.value))) {
            return;
        }
        try (FileSystem baloFS = this.createBaloArchive(baloFilePath);){
            this.populateBaloArchive(baloFS, module, moduleDependencyList);
            this.buildContext.out().println("\t" + projectDirectory.relativize(baloFilePath));
        }
        catch (IOException e) {
            throw new BLangCompilerException("Failed to create balo :" + e.getMessage(), (Throwable)e);
        }
        catch (BLangCompilerException be) {
            try {
                Files.delete(baloFilePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw be;
        }
    }

    private FileSystem createBaloArchive(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        env.put("encoding", "UTF-8");
        URI zipDisk = URI.create("jar:" + path.toUri());
        return FileSystems.newFileSystem(zipDisk, env);
    }

    private void populateBaloArchive(FileSystem baloFS, BLangPackage module, HashSet<Path> moduleDependencyList) throws IOException {
        Path root = baloFS.getPath("/", new String[0]);
        Path projectDirectory = this.sourceDirectory.getPath();
        Path moduleSourceDir = projectDirectory.resolve("src").resolve(module.packageID.name.value);
        String moduleName = module.packageID.name.value;
        Path manifest = projectDirectory.resolve("Ballerina.toml");
        this.addMetaData(root, module, manifest);
        this.addModuleSource(root, baloFS, moduleSourceDir, moduleName);
        this.addResources(root, baloFS, moduleSourceDir);
        this.addModuleDoc(root, moduleSourceDir);
        if (!this.manifest.isTemplateModule(moduleName)) {
            this.addPlatformLibs(root, projectDirectory, moduleName, moduleDependencyList);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private byte[] populateTomlWithDependencies(BLangPackage module, byte[] manifestBytes) {
        block38: {
            try {
                Throwable throwable = null;
                try (ByteArrayInputStream tomlStream = new ByteArrayInputStream(manifestBytes);){
                    LinkedList<Dependency> dependenciesToAdd = new LinkedList<Dependency>();
                    LockFile lockFile = LockFileProcessor.parseTomlContentAsStream((InputStream)this.sourceDirectory.getLockFileContent());
                    String moduleAlias = module.packageID.orgName.value + "/" + module.packageID.name.value;
                    if (null != lockFile && null != lockFile.getImports() && lockFile.getImports().size() > 0 && lockFile.getImports().containsKey(moduleAlias)) {
                        List moduleImports = (List)lockFile.getImports().get(moduleAlias);
                        for (LockFileImport lockFileImport : moduleImports) {
                            Dependency dependency = new Dependency();
                            dependency.setModuleID(lockFileImport.getOrgName() + "/" + lockFileImport.getName());
                            DependencyMetadata depMeta = new DependencyMetadata();
                            depMeta.setVersion(lockFileImport.getVersion());
                            dependency.setMetadata(depMeta);
                            dependenciesToAdd.add(dependency);
                        }
                    }
                    Manifest manifest = ManifestProcessor.parseTomlContentAsStream((InputStream)tomlStream);
                    for (BLangImportPackage bLangImportPackage : module.imports) {
                        if (!bLangImportPackage.symbol.pkgID.orgName.value.equals(module.packageID.orgName.value) || !ProjectDirs.isModuleExist((Path)this.sourceDirectory.getPath(), (String)bLangImportPackage.symbol.pkgID.name.value)) continue;
                        Optional<Dependency> manifestDependency = manifest.getDependencies().stream().filter(dep -> dep.getOrgName().equals(importz.symbol.pkgID.orgName.value)).filter(dep -> dep.getModuleName().equals(importz.symbol.pkgID.name.value)).findAny();
                        if (!manifestDependency.isPresent()) {
                            Dependency dependency = new Dependency();
                            dependency.setModuleID(bLangImportPackage.symbol.pkgID.orgName.value + "/" + bLangImportPackage.symbol.pkgID.name.value);
                            DependencyMetadata depMeta = new DependencyMetadata();
                            depMeta.setVersion(bLangImportPackage.symbol.pkgID.version.value);
                            dependency.setMetadata(depMeta);
                            dependenciesToAdd.add(dependency);
                            continue;
                        }
                        if (null == ((Dependency)manifestDependency.get()).getMetadata() || null == ((Dependency)manifestDependency.get()).getMetadata().getVersion() || bLangImportPackage.symbol.pkgID.version.value.equals(((Dependency)manifestDependency.get()).getMetadata().getVersion())) continue;
                        throw new BLangCompilerException("version specified for '" + ((Dependency)manifestDependency.get()).toString() + "' in Ballerina.toml should be '" + bLangImportPackage.symbol.pkgID.toString() + "'.");
                    }
                    for (Dependency dependency : dependenciesToAdd) {
                        for (Dependency dependencyInManifest : manifest.getDependencies()) {
                            if (!dependency.getOrgName().equals(dependencyInManifest.getOrgName()) || !dependency.getModuleName().equals(dependencyInManifest.getModuleName()) || null == dependency.getMetadata() || null == dependencyInManifest.getMetadata() || null == dependency.getMetadata().getVersion() || null == dependencyInManifest.getMetadata().getVersion() || dependency.getMetadata().getVersion().equals(dependencyInManifest.getMetadata().getVersion())) continue;
                            throw new BLangCompilerException("version specified for '" + dependencyInManifest.toString() + "' in Ballerina.toml should be '" + dependency.getMetadata().getVersion() + "'. you can either update the Ballerina.toml or remove the Ballerina.lock file.");
                        }
                    }
                    Platform platform = manifest.getPlatform();
                    if (platform.libraries != null) {
                        for (Library platformLib : platform.libraries) {
                            if (platformLib.getPath() != null || platformLib.getArtifactId() != null && platformLib.getGroupId() != null && platformLib.getVersion() != null) continue;
                            throw new BLangCompilerException("path or maven dependency properties are not specified for given platform library dependency.");
                        }
                    }
                    if (dependenciesToAdd.size() > 0) {
                        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(manifestBytes);){
                            byte[] byArray = ManifestProcessor.addDependenciesToManifest((ByteArrayInputStream)byteArrayInputStream, dependenciesToAdd);
                            return byArray;
                        }
                    }
                    break block38;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException | TomlException throwable) {
                // empty catch block
            }
        }
        return manifestBytes;
    }

    private void addModuleDoc(Path root, Path moduleSourceDir) throws IOException {
        Path moduleMd = moduleSourceDir.resolve("Module.md");
        Path docsDirInBalo = root.resolve("docs");
        Path moduleMdInBalo = docsDirInBalo.resolve("Module.md");
        Files.createDirectory(docsDirInBalo, new FileAttribute[0]);
        if (Files.exists(moduleMd, new LinkOption[0])) {
            Files.copy(moduleMd, moduleMdInBalo, new CopyOption[0]);
        }
    }

    private void addPlatformLibs(Path root, Path projectDirectory, String moduleName, HashSet<Path> moduleDependencyList) throws IOException {
        if (null != this.manifest.getPlatform().libraries) {
            Path platformLibsDir = root.resolve("platform-libs");
            Files.createDirectory(platformLibsDir, new FileAttribute[0]);
            List libs = this.manifest.getPlatform().libraries.stream().filter(lib -> lib.getModules() == null || Arrays.asList(lib.getModules()).contains(moduleName)).map(lib -> Paths.get(lib.getPath(), new String[0])).collect(Collectors.toList());
            for (Path lib2 : libs) {
                Path nativeFile = projectDirectory.resolve(lib2);
                Path libFileName = lib2.getFileName();
                if (null == libFileName) continue;
                Path targetPath = platformLibsDir.resolve(libFileName.toString());
                try {
                    Files.copy(nativeFile, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    moduleDependencyList.add(nativeFile);
                }
                catch (IOException e) {
                    throw new BLangCompilerException("Dependency jar not found : " + lib2.toString());
                }
            }
        }
    }

    private void addResources(Path root, FileSystem fs, Path moduleSourceDir) throws IOException {
        Path resourceDir = moduleSourceDir.resolve("resources");
        Path resourceDirInBalo = root.resolve("resources");
        Files.createDirectory(resourceDirInBalo, new FileAttribute[0]);
        if (Files.exists(resourceDir, new LinkOption[0])) {
            PathMatcher filter = fs.getPathMatcher("glob:**");
            Files.walkFileTree(resourceDir, new Copy(resourceDir, resourceDirInBalo, filter, filter));
        }
    }

    private void addModuleSource(Path root, FileSystem fs, Path moduleSourceDir, String moduleName) throws IOException {
        Path srcInBalo = root.resolve("src");
        Files.createDirectory(srcInBalo, new FileAttribute[0]);
        Path moduleDirInBalo = srcInBalo.resolve(moduleName);
        Files.createDirectory(moduleDirInBalo, new FileAttribute[0]);
        boolean isTemplate = this.manifest.isTemplateModule(moduleName);
        PathMatcher fileFilter = fs.getPathMatcher("glob:**/*.bal");
        PathMatcher dirFilter = path -> {
            String prefix = moduleDirInBalo.resolve("resources").toString();
            if (fs.getPathMatcher("glob:" + prefix + "**").matches(path)) {
                return false;
            }
            prefix = moduleDirInBalo.resolve("tests").toString();
            return isTemplate || !fs.getPathMatcher("glob:" + prefix + "**").matches(path);
        };
        Files.walkFileTree(moduleSourceDir, new Copy(moduleSourceDir, moduleDirInBalo, fileFilter, dirFilter));
    }

    private void addMetaData(Path root, BLangPackage module, Path manifestPath) throws IOException {
        Path metaDir = root.resolve("metadata");
        Path baloMetaFile = metaDir.resolve("BALO.toml");
        Path moduleMetaFile = metaDir.resolve("MODULE.toml");
        Path baloManifest = metaDir.resolve("Ballerina.toml");
        Files.createDirectories(metaDir, new FileAttribute[0]);
        TomlWriter writer = new TomlWriter();
        String baloToml = writer.write((Object)new BaloToml());
        Files.write(baloMetaFile, baloToml.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        Module moduleObj = new Module();
        moduleObj.setModule_name(module.packageID.name.value);
        moduleObj.setModule_organization(this.manifest.getProject().getOrgName());
        moduleObj.setModule_version(this.manifest.getProject().getVersion());
        moduleObj.setModule_authors(this.manifest.getProject().getAuthors());
        moduleObj.setModule_keywords(this.manifest.getProject().getKeywords());
        moduleObj.setModule_source_repository(this.manifest.getProject().getRepository());
        moduleObj.setModule_licenses(this.manifest.getProject().getLicense());
        moduleObj.setPlatform(this.manifest.getTargetPlatform(module.packageID.name.value));
        moduleObj.setBallerina_version(RepoUtils.getBallerinaVersion());
        moduleObj.setTemplate(String.valueOf(this.manifest.getProject().getTemplates().contains(module.packageID.name.value)));
        String moduleToml = writer.write((Object)moduleObj);
        Files.write(moduleMetaFile, moduleToml.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        byte[] manifestBytes = Files.readAllBytes(manifestPath);
        byte[] tomlBytes = this.populateTomlWithDependencies(module, manifestBytes);
        if (null != tomlBytes) {
            Files.write(baloManifest, tomlBytes, new OpenOption[0]);
        }
    }

    static class Copy
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;
        private StandardCopyOption copyOption;
        private PathMatcher fileFilter;
        private PathMatcher dirFilter;

        public Copy(Path fromPath, Path toPath, PathMatcher file, PathMatcher dir) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = StandardCopyOption.REPLACE_EXISTING;
            this.fileFilter = file;
            this.dirFilter = dir;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir).toString());
            if (!this.dirFilter.matches(targetPath)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(file).toString());
            if (this.fileFilter.matches(targetPath)) {
                Files.copy(file, targetPath, this.copyOption);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

