/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.compiler;

import java.util.List;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.util.AbstractTransportCompilerPlugin;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="socket", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="socket", name="Client")})
public class SocketCompilerPlugin
extends AbstractTransportCompilerPlugin {
    private static final String INVALID_RESOURCE_SIGNATURE = "Invalid resource signature for %s in service %s. ";
    private static final String INVALID_RETURN = "Resource should not have any return type.";
    private DiagnosticLog diagnosticLog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.diagnosticLog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        int resourceCount = 0;
        int mandatoryResourceCount = 3;
        List resources = serviceNode.getResources();
        for (BLangFunction resource : resources) {
            resourceCount += this.validate(serviceNode.getName().getValue(), resource, this.diagnosticLog);
        }
        if (resourceCount != mandatoryResourceCount) {
            String errorMsg = "Service needs to have all 3 resources [%s, %s, %s].";
            String msg = String.format(errorMsg, "onConnect", "onReadReady", "onError");
            this.diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)msg);
        }
    }

    private int validate(String serviceName, BLangFunction resource, DiagnosticLog diagnosticLog) {
        int resourceCount = 0;
        switch (resource.getName().getValue()) {
            case "onConnect": {
                this.validateOnAccept(serviceName, resource, diagnosticLog);
                ++resourceCount;
                break;
            }
            case "onReadReady": {
                this.validateOnReadReady(serviceName, resource, diagnosticLog);
                ++resourceCount;
                break;
            }
            case "onError": {
                this.validateOnError(serviceName, resource, diagnosticLog);
                ++resourceCount;
                break;
            }
        }
        return resourceCount;
    }

    private void validateOnError(String serviceName, BLangFunction resource, DiagnosticLog diagnosticLog) {
        List readReadyParams = resource.getParameters();
        if (readReadyParams.size() != 2) {
            String msg = String.format("Invalid resource signature for %s in service %s. Parameters should be a 'socket:Caller' and 'error'", resource.getName().getValue(), serviceName);
            diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
            return;
        }
        this.validateEndpointCaller(serviceName, resource, diagnosticLog, readReadyParams);
        BType error = ((BLangSimpleVariable)readReadyParams.get((int)1)).getTypeNode().type;
        if (TypeKind.RECORD.equals((Object)error.getKind()) && error.tag == 29 && !"error".equals(error.tsymbol.toString())) {
            String msg = String.format("Invalid resource signature for %s in service %s. The second parameter should be an 'error'", resource.getName().getValue(), serviceName);
            diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
        }
        this.validateReturns(resource, diagnosticLog);
    }

    private void validateOnReadReady(String serviceName, BLangFunction resource, DiagnosticLog diagnosticLog) {
        List readReadyParams = resource.getParameters();
        if (readReadyParams.size() != 1) {
            String msg = String.format("Invalid resource signature for %s in service %s. Parameters should be a 'socket:Caller'", resource.getName().getValue(), serviceName);
            diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
            return;
        }
        this.validateEndpointCaller(serviceName, resource, diagnosticLog, readReadyParams);
        this.validateReturns(resource, diagnosticLog);
    }

    private void validateOnAccept(String serviceName, BLangFunction resource, DiagnosticLog diagnosticLog) {
        List acceptParams = resource.getParameters();
        if (acceptParams.size() != 1) {
            String msg = String.format("Invalid resource signature for %s in service %s. The parameter should be a 'socket:Caller'", resource.getName().getValue(), serviceName);
            diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
            return;
        }
        this.validateEndpointCaller(serviceName, resource, diagnosticLog, acceptParams);
        this.validateReturns(resource, diagnosticLog);
    }

    private void validateReturns(BLangFunction resource, DiagnosticLog diagnosticLog) {
        if (!this.isResourceReturnsErrorOrNil((FunctionNode)resource)) {
            diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)INVALID_RETURN);
        }
    }

    private void validateEndpointCaller(String serviceName, BLangFunction resource, DiagnosticLog diagnosticLog, BStructureType event) {
        String eventType = event.tsymbol.toString();
        if (!"ballerina/socket:Listener".equals(eventType) && !"ballerina/socket:Client".equals(eventType)) {
            String msg = String.format("Invalid resource signature for %s in service %s. The parameter should be a 'socket:Caller'", resource.getName().getValue(), serviceName);
            diagnosticLog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)msg);
        }
    }

    private void validateEndpointCaller(String serviceName, BLangFunction resource, DiagnosticLog diagnosticLog, List<BLangSimpleVariable> params) {
        BType caller = params.get((int)0).type;
        if (TypeKind.OBJECT.equals((Object)caller.getKind()) && caller.tag == 35) {
            this.validateEndpointCaller(serviceName, resource, diagnosticLog, (BStructureType)new BObjectType(caller.tsymbol));
        }
    }
}

