/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.client;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="initEndpoint", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/socket"), isPublic=true)
public class InitEndpoint {
    private static final Logger log = LoggerFactory.getLogger(InitEndpoint.class);

    public static Object initEndpoint(Strand strand, ObjectValue client, MapValue<String, Object> config) {
        ErrorValue returnValue = null;
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            socketChannel.socket().setReuseAddress(true);
            client.addNativeData("Socket", (Object)socketChannel);
            client.addNativeData("isClient", (Object)true);
            ObjectValue callbackService = (ObjectValue)config.get((Object)"callbackService");
            client.addNativeData("config", config);
            long readTimeout = config.getIntValue("readTimeoutInMillis");
            client.addNativeData("socketService", (Object)new SocketService(socketChannel, strand.scheduler, callbackService, readTimeout));
        }
        catch (SocketException e) {
            returnValue = SocketUtils.createSocketError("Unable to bind the local socket port");
        }
        catch (IOException e) {
            log.error("Unable to initiate the client socket", (Throwable)e);
            returnValue = SocketUtils.createSocketError("Unable to initiate the socket");
        }
        return returnValue;
    }
}

