/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.client;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="shutdownRead", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/socket"), isPublic=true)
public class ShutdownRead {
    private static final Logger log = LoggerFactory.getLogger(ShutdownRead.class);

    public static Object shutdownRead(Strand strand, ObjectValue client) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        try {
            if (socketChannel != null) {
                socketChannel.shutdownInput();
            }
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("Socket is already closed");
        }
        catch (IOException e) {
            log.error("Unable to shutdown the read", (Throwable)e);
            return SocketUtils.createSocketError("Unable to shutdown the write");
        }
        catch (NotYetConnectedException e) {
            return SocketUtils.createSocketError("Socket is not yet connected");
        }
        return null;
    }
}

