/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="write", receiver=@Receiver(type=TypeKind.OBJECT, structType="Client", structPackage="ballerina/socket"), isPublic=true)
public class Write {
    private static final Logger log = LoggerFactory.getLogger(Write.class);

    public static Object write(Strand strand, ObjectValue client, ArrayValue content) {
        SocketChannel socketChannel = (SocketChannel)client.getNativeData("Socket");
        byte[] byteContent = content.getBytes();
        if (log.isDebugEnabled()) {
            log.debug("No of byte going to write[" + socketChannel.hashCode() + "]: " + byteContent.length);
        }
        ByteBuffer buffer = ByteBuffer.wrap(byteContent);
        try {
            int write = socketChannel.write(buffer);
            if (log.isDebugEnabled()) {
                log.debug("No of byte written for the client[" + socketChannel.hashCode() + "]: " + write);
            }
            return (long)write;
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("Client socket close already.");
        }
        catch (IOException e) {
            log.error("Unable to perform write[" + socketChannel.hashCode() + "]", (Throwable)e);
            return SocketUtils.createSocketError("Write failed.");
        }
        catch (NotYetConnectedException e) {
            return SocketUtils.createSocketError("Client socket not connected yet.");
        }
    }
}

