/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.server;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.concurrent.RejectedExecutionException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.exceptions.SelectorInitializeException;
import org.ballerinalang.stdlib.socket.tcp.ChannelRegisterCallback;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="start", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/socket"), isPublic=true)
public class Start {
    private static final Logger log = LoggerFactory.getLogger(Start.class);

    public static Object start(Strand strand, ObjectValue listener) {
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        try {
            ServerSocketChannel channel = (ServerSocketChannel)listener.getNativeData("ServerSocket");
            int port = (Integer)listener.getNativeData("port");
            MapValue config = (MapValue)listener.getNativeData("config");
            String networkInterface = (String)config.getNativeData("interface");
            if (networkInterface == null) {
                channel.bind(new InetSocketAddress(port));
            } else {
                channel.bind(new InetSocketAddress(networkInterface, port));
            }
            SelectorManager selectorManager = SelectorManager.getInstance();
            selectorManager.start();
            SocketService socketService = (SocketService)listener.getNativeData("socketService");
            ChannelRegisterCallback registerCallback = new ChannelRegisterCallback(socketService, callback, 16);
            selectorManager.registerChannel(registerCallback);
            String socketListenerStarted = "[ballerina/socket] started socket listener ";
            PrintStream console = System.out;
            console.println(socketListenerStarted + channel.socket().getLocalPort());
        }
        catch (SelectorInitializeException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("Unable to initialize the selector"));
        }
        catch (CancelledKeyException e) {
            callback.notifyFailure(SocketUtils.createSocketError("Server socket registration is failed"));
        }
        catch (AlreadyBoundException e) {
            callback.notifyFailure(SocketUtils.createSocketError("Server socket service is already bound to a port"));
        }
        catch (UnsupportedAddressTypeException e) {
            log.error("Address not supported", (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("Provided address is not supported"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("Unable to start the socket service: " + e.getMessage()));
        }
        catch (RejectedExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure(SocketUtils.createSocketError("Unable to start the socket listener."));
        }
        return null;
    }
}

