/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp.server;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="stop", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/socket"), isPublic=true)
public class Stop {
    private static final Logger log = LoggerFactory.getLogger(Stop.class);

    public static Object stop(Strand strand, ObjectValue listener) {
        try {
            ServerSocketChannel channel = (ServerSocketChannel)listener.getNativeData("ServerSocket");
            SelectorManager selectorManager = SelectorManager.getInstance();
            selectorManager.unRegisterChannel(channel);
            channel.close();
            selectorManager.stop();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return SocketUtils.createSocketError("Unable to stop the socket listener: " + e.getMessage());
        }
        return null;
    }
}

