/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.udp.client;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="close", receiver=@Receiver(type=TypeKind.OBJECT, structType="UdpClient", structPackage="ballerina/socket"), isPublic=true)
public class Close {
    private static final Logger log = LoggerFactory.getLogger(Close.class);

    public static Object close(Strand strand, ObjectValue client) {
        DatagramChannel socketChannel = (DatagramChannel)client.getNativeData("Socket");
        try {
            if (socketChannel != null) {
                socketChannel.close();
                SelectorManager.getInstance().unRegisterChannel(socketChannel);
            }
            if (Boolean.parseBoolean(client.getNativeData("isClient").toString())) {
                SelectorManager.getInstance().stop();
            }
        }
        catch (IOException e) {
            log.error("Unable to close the socket", (Throwable)e);
            return SocketUtils.createSocketError("Unable to close the client socket");
        }
        return null;
    }
}

