/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.udp.client;

import java.nio.channels.DatagramChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingCallback;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingSocketMap;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="receiveFrom", receiver=@Receiver(type=TypeKind.OBJECT, structType="UdpClient", structPackage="ballerina/socket"), isPublic=true)
public class ReceiveFrom {
    private static final Logger log = LoggerFactory.getLogger(ReceiveFrom.class);

    public static Object receiveFrom(Strand strand, ObjectValue client, long length) {
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        if (length != -100L && length < 1L) {
            String msg = "Requested byte length need to be 1 or more";
            callback.notifyFailure(SocketUtils.createSocketError(msg));
            return null;
        }
        DatagramChannel socket = (DatagramChannel)client.getNativeData("Socket");
        int socketHash = socket.hashCode();
        SocketService socketService = (SocketService)client.getNativeData("socketService");
        ReadPendingCallback readPendingCallback = new ReadPendingCallback(callback, (int)length, socketHash, socketService.getReadTimeout());
        ReadPendingSocketMap.getInstance().add(socket.hashCode(), readPendingCallback);
        log.debug("Notify to invokeRead");
        SelectorManager.getInstance().invokeRead(socketHash, false);
        return null;
    }
}

