/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.udp.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="socket", functionName="sendTo", receiver=@Receiver(type=TypeKind.OBJECT, structType="UdpClient", structPackage="ballerina/socket"), isPublic=true)
public class SendTo {
    private static final Logger log = LoggerFactory.getLogger(SendTo.class);

    public static Object sendTo(Strand strand, ObjectValue client, ArrayValue content, MapValue<String, Object> address) {
        DatagramChannel socket = (DatagramChannel)client.getNativeData("Socket");
        String host = address.getStringValue("host");
        int port = address.getIntValue("port").intValue();
        byte[] byteContent = content.getBytes();
        if (log.isDebugEnabled()) {
            log.debug("No of byte going to write[" + socket.hashCode() + "]: " + byteContent.length);
        }
        try {
            InetSocketAddress remote = new InetSocketAddress(host, port);
            int write = socket.send(ByteBuffer.wrap(byteContent), remote);
            if (log.isDebugEnabled()) {
                log.debug("No of byte written for the client[" + socket.hashCode() + "]: " + write);
            }
            return write;
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("Client socket close already.");
        }
        catch (IOException e) {
            log.error("Unable to perform write[" + socket.hashCode() + "]", (Throwable)e);
            return SocketUtils.createSocketError("Write failed.");
        }
    }
}

