/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.stdlib.socket.tcp.SocketReader;

public class ReadReadySocketMap {
    private ConcurrentHashMap<Integer, SocketReader> socketReaderMap = new ConcurrentHashMap();

    private ReadReadySocketMap() {
    }

    public static ReadReadySocketMap getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void add(SocketReader socketReader) {
        this.socketReaderMap.put(socketReader.getSocketService().getSocketChannel().hashCode(), socketReader);
    }

    public SocketReader remove(int hashId) {
        return this.socketReaderMap.remove(hashId);
    }

    public SocketReader get(int hashId) {
        return this.socketReaderMap.get(hashId);
    }

    public boolean isReadReady(int hashId) {
        return this.socketReaderMap.containsKey(hashId);
    }

    private static class LazyHolder {
        private static final ReadReadySocketMap INSTANCE = new ReadReadySocketMap();

        private LazyHolder() {
        }
    }
}

