/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.ballerinalang.stdlib.socket.tcp.TCPSocketCallback;
import org.ballerinalang.stdlib.socket.tcp.TCPSocketReadCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorDispatcher {
    private static final Logger log = LoggerFactory.getLogger(SelectorDispatcher.class);

    static void invokeOnError(SocketService socketService, String errorMsg) {
        try {
            Object[] params = SelectorDispatcher.getOnErrorResourceSignature(socketService, errorMsg);
            Executor.submit((Scheduler)socketService.getScheduler(), (ObjectValue)socketService.getService(), (String)"onError", (CallableUnitCallback)new TCPSocketCallback(socketService), null, (Object[])params);
        }
        catch (Throwable e) {
            log.error("Error while executing onError resource", e);
        }
    }

    static void invokeOnError(SocketService socketService, TCPSocketCallback callback, ErrorValue error) {
        try {
            ObjectValue caller = SocketUtils.createClient(socketService);
            Object[] params = new Object[]{caller, true, error, true};
            Executor.submit((Scheduler)socketService.getScheduler(), (ObjectValue)socketService.getService(), (String)"onError", (CallableUnitCallback)callback, null, (Object[])params);
        }
        catch (Throwable e) {
            log.error("Error while executing onError resource", e);
        }
    }

    static void invokeReadReady(SocketService socketService) {
        try {
            Object[] params = SelectorDispatcher.getReadReadyResourceSignature(socketService);
            Executor.submit((Scheduler)socketService.getScheduler(), (ObjectValue)socketService.getService(), (String)"onReadReady", (CallableUnitCallback)new TCPSocketReadCallback(socketService), null, (Object[])params);
        }
        catch (BallerinaConnectorException e) {
            SelectorDispatcher.invokeOnError(socketService, e.getMessage());
        }
    }

    static void invokeOnConnect(SocketService socketService) {
        try {
            ObjectValue clientObj = SocketUtils.createClient(socketService);
            Object[] params = new Object[]{clientObj, true};
            Executor.submit((Scheduler)socketService.getScheduler(), (ObjectValue)socketService.getService(), (String)"onConnect", (CallableUnitCallback)new TCPSocketCallback(socketService), null, (Object[])params);
        }
        catch (BallerinaConnectorException e) {
            SelectorDispatcher.invokeOnError(socketService, e.getMessage());
        }
    }

    private static Object[] getOnErrorResourceSignature(SocketService socketService, String msg) {
        ObjectValue caller = SocketUtils.createClient(socketService);
        ErrorValue error = SocketUtils.createSocketError(msg);
        return new Object[]{caller, true, error, true};
    }

    private static Object[] getReadReadyResourceSignature(SocketService socketService) {
        ObjectValue caller = SocketUtils.createClient(socketService);
        return new Object[]{caller, true};
    }
}

