/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.tcp;

import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.socket.SocketConstants;
import org.ballerinalang.stdlib.socket.tcp.SocketService;

public class SocketUtils {
    private static final String PACKAGE_SOCKET = "ballerina/socket";
    private static final String DETAIL_RECORD_TYPE_NAME = "Detail";

    public static ErrorValue createSocketError(String errMsg) {
        return BallerinaErrors.createError((String)SocketConstants.ErrorCode.GenericError.errorCode(), SocketUtils.createDetailRecord(errMsg, null));
    }

    public static ErrorValue createSocketError(SocketConstants.ErrorCode code, String errMsg) {
        return BallerinaErrors.createError((String)code.errorCode(), SocketUtils.createDetailRecord(errMsg, null));
    }

    private static MapValue<String, Object> createDetailRecord(Object ... values) {
        MapValue detail = BallerinaValues.createRecordValue((String)PACKAGE_SOCKET, (String)DETAIL_RECORD_TYPE_NAME);
        return BallerinaValues.createRecord((MapValue)detail, (Object[])values);
    }

    static ObjectValue createClient(SocketService socketService) {
        Object[] args = new Object[]{null};
        ObjectValue caller = BallerinaValues.createObjectValue((String)PACKAGE_SOCKET, (String)"Client", (Object[])args);
        caller.addNativeData("socketService", (Object)socketService);
        SocketChannel client = null;
        if (socketService.getSocketChannel() != null) {
            client = (SocketChannel)socketService.getSocketChannel();
        }
        if (client != null) {
            caller.addNativeData("Socket", (Object)client);
            Socket socket = client.socket();
            caller.set("remotePort", (Object)socket.getPort());
            caller.set("localPort", (Object)socket.getLocalPort());
            caller.set("remoteAddress", (Object)socket.getInetAddress().getHostAddress());
            caller.set("localAddress", (Object)socket.getLocalAddress().getHostAddress());
            caller.set("id", (Object)client.hashCode());
        }
        return caller;
    }

    public static byte[] getByteArrayFromByteBuffer(ByteBuffer content) {
        int contentLength = content.position();
        byte[] bytesArray = new byte[contentLength];
        content.flip();
        content.get(bytesArray, 0, contentLength);
        return bytesArray;
    }

    public static void shutdownExecutor(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
        }
    }
}

