/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.tcp;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.concurrent.RejectedExecutionException;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.stdlib.socket.exceptions.SelectorInitializeException;
import org.ballerinalang.stdlib.socket.tcp.ChannelRegisterCallback;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerActions {
    private static final Logger log = LoggerFactory.getLogger(ServerActions.class);

    public static Object initServer(ObjectValue listener, long port, MapValue<String, Object> config) {
        try {
            ServerSocketChannel serverSocket = ServerSocketChannel.open();
            serverSocket.configureBlocking(false);
            serverSocket.socket().setReuseAddress(true);
            listener.addNativeData("ServerSocket", (Object)serverSocket);
            listener.addNativeData("config", config);
            listener.addNativeData("port", (Object)((int)port));
            long timeout = config.getIntValue("readTimeoutInMillis");
            listener.addNativeData("readTimeoutInMillis", (Object)timeout);
        }
        catch (SocketException e) {
            return SocketUtils.createSocketError("unable to bind the socket port");
        }
        catch (IOException e) {
            log.error("Unable to initiate the socket listener", (Throwable)e);
            return SocketUtils.createSocketError("unable to initiate the socket listener");
        }
        return null;
    }

    public static Object register(ObjectValue listener, ObjectValue service) {
        SocketService socketService = ServerActions.getSocketService(listener, Scheduler.getStrand().scheduler, service);
        listener.addNativeData("socketService", (Object)socketService);
        return null;
    }

    private static SocketService getSocketService(ObjectValue listener, Scheduler scheduler, ObjectValue service) {
        ServerSocketChannel serverSocket = (ServerSocketChannel)listener.getNativeData("ServerSocket");
        long timeout = (Long)listener.getNativeData("readTimeoutInMillis");
        return new SocketService(serverSocket, scheduler, service, timeout);
    }

    public static Object start(ObjectValue listener) {
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        try {
            ServerSocketChannel channel = (ServerSocketChannel)listener.getNativeData("ServerSocket");
            int port = (Integer)listener.getNativeData("port");
            MapValue config = (MapValue)listener.getNativeData("config");
            String networkInterface = (String)config.getNativeData("interface");
            if (networkInterface == null) {
                channel.bind(new InetSocketAddress(port));
            } else {
                channel.bind(new InetSocketAddress(networkInterface, port));
            }
            SelectorManager selectorManager = SelectorManager.getInstance();
            selectorManager.start();
            SocketService socketService = (SocketService)listener.getNativeData("socketService");
            ChannelRegisterCallback registerCallback = new ChannelRegisterCallback(socketService, callback, 16);
            selectorManager.registerChannel(registerCallback);
            String socketListenerStarted = "[ballerina/socket] started socket listener ";
            PrintStream console = System.out;
            console.println(socketListenerStarted + channel.socket().getLocalPort());
        }
        catch (SelectorInitializeException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to initialize the selector"));
        }
        catch (CancelledKeyException e) {
            callback.notifyFailure((BError)SocketUtils.createSocketError("server socket registration is failed"));
        }
        catch (AlreadyBoundException e) {
            callback.notifyFailure((BError)SocketUtils.createSocketError("server socket service is already bound to a port"));
        }
        catch (UnsupportedAddressTypeException e) {
            log.error("Address not supported", (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("provided address is not supported"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to start the socket service: " + e.getMessage()));
        }
        catch (RejectedExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to start the socket listener."));
        }
        return null;
    }

    public static Object stop(ObjectValue listener, boolean graceful) {
        try {
            ServerSocketChannel channel = (ServerSocketChannel)listener.getNativeData("ServerSocket");
            SelectorManager selectorManager = SelectorManager.getInstance();
            selectorManager.unRegisterChannel(channel);
            channel.close();
            selectorManager.stop(graceful);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return SocketUtils.createSocketError("unable to stop the socket listener: " + e.getMessage());
        }
        return null;
    }
}

