/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.socket.endpoint.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.stdlib.socket.exceptions.SelectorInitializeException;
import org.ballerinalang.stdlib.socket.tcp.ChannelRegisterCallback;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingCallback;
import org.ballerinalang.stdlib.socket.tcp.ReadPendingSocketMap;
import org.ballerinalang.stdlib.socket.tcp.SelectorManager;
import org.ballerinalang.stdlib.socket.tcp.SocketService;
import org.ballerinalang.stdlib.socket.tcp.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientActions {
    private static final Logger log = LoggerFactory.getLogger(ClientActions.class);

    public static Object close(ObjectValue client) {
        DatagramChannel socketChannel = (DatagramChannel)client.getNativeData("Socket");
        try {
            if (socketChannel != null) {
                socketChannel.close();
                SelectorManager.getInstance().unRegisterChannel(socketChannel);
            }
            if (Boolean.parseBoolean(client.getNativeData("isClient").toString())) {
                SelectorManager.getInstance().stop(true);
            }
        }
        catch (IOException e) {
            log.error("Unable to close the socket", (Throwable)e);
            return SocketUtils.createSocketError("unable to close the client socket. " + e.getMessage());
        }
        return null;
    }

    public static Object initEndpoint(ObjectValue client, Object address, MapValue<String, Object> config) {
        SelectorManager selectorManager;
        SocketService socketService;
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        try {
            DatagramChannel socketChannel = DatagramChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.socket().setReuseAddress(true);
            client.addNativeData("Socket", (Object)socketChannel);
            client.addNativeData("isClient", (Object)true);
            if (address != null) {
                MapValue addressRecord = (MapValue)address;
                String host = addressRecord.getStringValue("host");
                int port = addressRecord.getIntValue("port").intValue();
                if (host == null) {
                    socketChannel.bind(new InetSocketAddress(port));
                } else {
                    socketChannel.bind(new InetSocketAddress(host, port));
                }
            }
            long timeout = config.getIntValue("readTimeoutInMillis");
            socketService = new SocketService(socketChannel, Scheduler.getStrand().scheduler, null, timeout);
            client.addNativeData("socketService", (Object)socketService);
            selectorManager = SelectorManager.getInstance();
            selectorManager.start();
        }
        catch (SelectorInitializeException e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to initialize the selector"));
            return null;
        }
        catch (SocketException e) {
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to bind the local socket port"));
            return null;
        }
        catch (IOException e) {
            log.error("Unable to initiate the client socket", (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to initiate the socket: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            callback.notifyFailure((BError)SocketUtils.createSocketError("unable to start the socket client."));
            return null;
        }
        selectorManager.registerChannel(new ChannelRegisterCallback(socketService, callback, 1));
        return null;
    }

    public static Object receiveFrom(ObjectValue client, long length) {
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        if (length != -100L && length < 1L) {
            String msg = "requested byte length need to be 1 or more";
            callback.notifyFailure((BError)SocketUtils.createSocketError(msg));
            return null;
        }
        DatagramChannel socket = (DatagramChannel)client.getNativeData("Socket");
        int socketHash = socket.hashCode();
        SocketService socketService = (SocketService)client.getNativeData("socketService");
        ReadPendingCallback readPendingCallback = new ReadPendingCallback(callback, (int)length, socketHash, socketService.getReadTimeout());
        ReadPendingSocketMap.getInstance().add(socket.hashCode(), readPendingCallback);
        log.debug("Notify to invokeRead");
        SelectorManager.getInstance().invokeRead(socketHash, false);
        return null;
    }

    public static Object sendTo(ObjectValue client, ArrayValue content, MapValue<String, Object> address) {
        DatagramChannel socket = (DatagramChannel)client.getNativeData("Socket");
        String host = address.getStringValue("host");
        int port = address.getIntValue("port").intValue();
        byte[] byteContent = content.getBytes();
        if (log.isDebugEnabled()) {
            log.debug(String.format("No of byte going to write[%d]: %d", socket.hashCode(), byteContent.length));
        }
        try {
            InetSocketAddress remote = new InetSocketAddress(host, port);
            int write = socket.send(ByteBuffer.wrap(byteContent), remote);
            if (log.isDebugEnabled()) {
                log.debug(String.format("No of byte written for the client[%d]: %d", socket.hashCode(), write));
            }
            return write;
        }
        catch (ClosedChannelException e) {
            return SocketUtils.createSocketError("client socket close already.");
        }
        catch (IOException e) {
            log.error("Unable to perform write[" + socket.hashCode() + "]", (Throwable)e);
            return SocketUtils.createSocketError("write failed. " + e.getMessage());
        }
    }
}

