/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.sql.datasource.PoolKey;
import org.ballerinalang.sql.datasource.SQLDatasourceUtils;
import org.ballerinalang.sql.utils.ErrorGenerator;

public class SQLDatasource {
    private HikariDataSource hikariDataSource;
    private AtomicInteger clientCounter = new AtomicInteger(0);
    private Lock mutex = new ReentrantLock();
    private boolean poolShutdown = false;

    private SQLDatasource(SQLDatasourceParams sqlDatasourceParams) {
        this.buildDataSource(sqlDatasourceParams);
        try {
            Connection con = this.getSQLConnection();
            Throwable throwable = null;
            if (con != null) {
                if (throwable != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    con.close();
                }
            }
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while obtaining connection for ClientConnector, ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLDatasource retrieveDatasource(SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource existingSqlDatasource;
        PoolKey poolKey = new PoolKey(sqlDatasourceParams.url, sqlDatasourceParams.options);
        Map<PoolKey, SQLDatasource> hikariDatasourceMap = SQLDatasourceUtils.retrieveDatasourceContainer((MapValue<String, Object>)sqlDatasourceParams.connectionPool);
        if (hikariDatasourceMap == null) {
            hikariDatasourceMap = SQLDatasourceUtils.putDatasourceContainer((MapValue<String, Object>)sqlDatasourceParams.connectionPool, new ConcurrentHashMap<PoolKey, SQLDatasource>());
        }
        SQLDatasource sqlDatasourceToBeReturned = existingSqlDatasource = hikariDatasourceMap.get(poolKey);
        if (existingSqlDatasource != null) {
            existingSqlDatasource.acquireMutex();
            try {
                if (!existingSqlDatasource.isPoolShutdown()) {
                    existingSqlDatasource.incrementClientCounter();
                }
                sqlDatasourceToBeReturned = hikariDatasourceMap.compute(poolKey, (key, value) -> SQLDatasource.createAndInitDatasource(sqlDatasourceParams));
            }
            finally {
                existingSqlDatasource.releaseMutex();
            }
        } else {
            sqlDatasourceToBeReturned = hikariDatasourceMap.computeIfAbsent(poolKey, key -> SQLDatasource.createAndInitDatasource(sqlDatasourceParams));
        }
        return sqlDatasourceToBeReturned;
    }

    private static SQLDatasource createAndInitDatasource(SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource newSqlDatasource = new SQLDatasource(sqlDatasourceParams);
        newSqlDatasource.incrementClientCounter();
        return newSqlDatasource;
    }

    public Connection getSQLConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }

    private void closeConnectionPool() {
        this.hikariDataSource.close();
        this.poolShutdown = true;
    }

    private boolean isPoolShutdown() {
        return this.poolShutdown;
    }

    private void incrementClientCounter() {
        this.clientCounter.incrementAndGet();
    }

    public void decrementClientCounterAndAttemptPoolShutdown() {
        this.acquireMutex();
        if (!this.poolShutdown && this.clientCounter.decrementAndGet() == 0) {
            this.closeConnectionPool();
        }
        this.releaseMutex();
    }

    private void releaseMutex() {
        this.mutex.unlock();
    }

    private void acquireMutex() {
        this.mutex.lock();
    }

    private void buildDataSource(SQLDatasourceParams sqlDatasourceParams) {
        try {
            HikariConfig config = sqlDatasourceParams.poolProperties != null ? new HikariConfig(sqlDatasourceParams.poolProperties) : new HikariConfig();
            config.setJdbcUrl(sqlDatasourceParams.url);
            config.setUsername(sqlDatasourceParams.user);
            config.setPassword(sqlDatasourceParams.password);
            if (!(sqlDatasourceParams.datasourceName == null || sqlDatasourceParams.datasourceName.isEmpty() || sqlDatasourceParams.options != null && sqlDatasourceParams.options.containsKey((Object)"url"))) {
                config.addDataSourceProperty("url", (Object)sqlDatasourceParams.url);
            }
            config.setDataSourceClassName(sqlDatasourceParams.datasourceName);
            if (sqlDatasourceParams.connectionPool != null) {
                int minIdleConnections;
                DecimalValue connLifeTime;
                Object connLifeTimeSec;
                int maxOpenConn = sqlDatasourceParams.connectionPool.getIntValue("maxOpenConnections").intValue();
                if (maxOpenConn > 0) {
                    config.setMaximumPoolSize(maxOpenConn);
                }
                if ((connLifeTimeSec = sqlDatasourceParams.connectionPool.get((Object)"maxConnectionLifeTimeInSeconds")) instanceof DecimalValue && (connLifeTime = (DecimalValue)connLifeTimeSec).floatValue() > 0.0) {
                    long connLifeTimeMS = Double.valueOf(connLifeTime.floatValue() * 1000.0).longValue();
                    config.setMaxLifetime(connLifeTimeMS);
                }
                if ((minIdleConnections = sqlDatasourceParams.connectionPool.getIntValue("minIdleConnections").intValue()) > 0) {
                    config.setMinimumIdle(minIdleConnections);
                }
            }
            if (sqlDatasourceParams.options != null) {
                MapValue optionMap = sqlDatasourceParams.options;
                optionMap.entrySet().forEach(entry -> {
                    if (!SQLDatasourceUtils.isSupportedDbOptionType(entry.getValue())) {
                        throw ErrorGenerator.getSQLApplicationError("unsupported type " + (String)entry.getKey() + " for the db option");
                    }
                    config.addDataSourceProperty((String)entry.getKey(), entry.getValue());
                });
            }
            this.hikariDataSource = new HikariDataSource(config);
            Runtime.getRuntime().addShutdownHook(new Thread(this::closeConnectionPool));
        }
        catch (Throwable t) {
            StringBuilder message = new StringBuilder("error in sql connector configuration: " + t.getMessage() + "");
            String lastCauseMessage = null;
            int count = 0;
            while (t.getCause() != null && count < 3) {
                lastCauseMessage = t.getCause().getMessage();
                message.append(" Caused by :").append(lastCauseMessage);
                ++count;
                t = t.getCause();
            }
            throw ErrorGenerator.getSQLApplicationError(message.toString());
        }
    }

    public static class SQLDatasourceParams {
        private String url;
        private String user;
        private String password;
        private String datasourceName;
        private MapValue connectionPool;
        private MapValue options;
        private Properties poolProperties;

        public SQLDatasourceParams setConnectionPool(MapValue connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public SQLDatasourceParams setUrl(String url) {
            this.url = url;
            return this;
        }

        public SQLDatasourceParams setUser(String user) {
            this.user = user;
            return this;
        }

        public SQLDatasourceParams setPassword(String password) {
            this.password = password;
            return this;
        }

        public SQLDatasourceParams setDatasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        public SQLDatasourceParams setOptions(MapValue options) {
            this.options = options;
            return this;
        }

        public SQLDatasourceParams setPoolProperties(Properties properties) {
            this.poolProperties = properties;
            return this;
        }
    }
}

