/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.datasource;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.sql.datasource.PoolKey;
import org.ballerinalang.sql.datasource.SQLDatasource;

public class SQLDatasourceUtils {
    private static final String POOL_MAP_KEY = UUID.randomUUID().toString();

    static Map<PoolKey, SQLDatasource> retrieveDatasourceContainer(MapValue<String, Object> poolOptions) {
        return (ConcurrentHashMap)poolOptions.getNativeData(POOL_MAP_KEY);
    }

    public static synchronized Map<PoolKey, SQLDatasource> putDatasourceContainer(MapValue<String, Object> poolOptions, ConcurrentHashMap<PoolKey, SQLDatasource> datasourceMap) {
        Map existingDataSourceMap = (Map)poolOptions.getNativeData(POOL_MAP_KEY);
        if (existingDataSourceMap != null) {
            return existingDataSourceMap;
        }
        poolOptions.addNativeData(POOL_MAP_KEY, datasourceMap);
        return datasourceMap;
    }

    static boolean isSupportedDbOptionType(Object value) {
        boolean supported = false;
        if (value != null) {
            BType type = TypeChecker.getType((Object)value);
            int typeTag = type.getTag();
            supported = typeTag == 5 || typeTag == 1 || typeTag == 3 || typeTag == 6 || typeTag == 4 || typeTag == 2;
        }
        return supported;
    }
}

