/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.sql.SQLException;
import java.util.HashMap;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.sql.Constants;

public class ErrorGenerator {
    private ErrorGenerator() {
    }

    public static ErrorValue getSQLDatabaseError(SQLException exception, String messagePrefix) {
        String sqlErrorMessage = exception.getMessage() != null ? exception.getMessage() : "Database Error Occurred";
        int vendorCode = exception.getErrorCode();
        String sqlState = exception.getSQLState();
        String errorMessage = messagePrefix + sqlErrorMessage + ".";
        return ErrorGenerator.getSQLDatabaseError(errorMessage, vendorCode, sqlState);
    }

    public static ErrorValue getSQLApplicationError(String detailedErrorMessage) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("message", detailedErrorMessage);
        MapValue sqlClientErrorDetailRecord = BallerinaValues.createRecordValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"ApplicationErrorData", valueMap);
        return BallerinaErrors.createError((String)"{ballerina/sql}ApplicationError", (MapValue)sqlClientErrorDetailRecord);
    }

    private static ErrorValue getSQLDatabaseError(String message, int vendorCode, String sqlState) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("message", message);
        valueMap.put("errorCode", vendorCode);
        valueMap.put("sqlState", sqlState);
        MapValue sqlClientErrorDetailRecord = BallerinaValues.createRecordValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"DatabaseErrorData", valueMap);
        return BallerinaErrors.createError((String)"{ballerina/sql}DatabaseError", (MapValue)sqlClientErrorDetailRecord);
    }
}

