/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.sql.exception.ApplicationError;
import org.ballerinalang.sql.utils.ColumnDefinition;
import org.ballerinalang.sql.utils.ErrorGenerator;
import org.ballerinalang.sql.utils.Utils;

public class RecordItertorUtils {
    private static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public static Object nextResult(ObjectValue recordIterator) {
        ResultSet resultSet = (ResultSet)recordIterator.getNativeData("ResultSet");
        try {
            if (resultSet.next()) {
                BStructureType streamConstraint = (BStructureType)recordIterator.getNativeData("recordType");
                MapValueImpl bStruct = new MapValueImpl((BType)streamConstraint);
                List columnDefinitions = (List)recordIterator.getNativeData("ColumnDefinition");
                for (int i = 0; i < columnDefinitions.size(); ++i) {
                    ColumnDefinition columnDefinition = (ColumnDefinition)columnDefinitions.get(i);
                    bStruct.put((Object)columnDefinition.getBallerinaFieldName(), RecordItertorUtils.getResult(resultSet, i + 1, columnDefinition.getSqlType(), columnDefinition.getBallerinaType()));
                }
                return bStruct;
            }
            return null;
        }
        catch (SQLException e) {
            return ErrorGenerator.getSQLDatabaseError(e, "Error when iterating the SQL result");
        }
        catch (IOException | ApplicationError e) {
            return ErrorGenerator.getSQLApplicationError("Error when iterating the SQL result. " + e.getMessage());
        }
        catch (Throwable throwable) {
            return ErrorGenerator.getSQLApplicationError("Error when iterating through the SQL result. " + throwable.getMessage());
        }
    }

    private static Object getResult(ResultSet resultSet, int columnIndex, int sqlType, BType ballerinaType) throws SQLException, ApplicationError, IOException {
        switch (sqlType) {
            case 2003: {
                return Utils.convert(resultSet.getArray(columnIndex), sqlType, ballerinaType);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return Utils.convert(resultSet.getString(columnIndex), sqlType, ballerinaType);
            }
            case -4: 
            case -3: 
            case -2: {
                return Utils.convert(resultSet.getBytes(columnIndex), sqlType, ballerinaType);
            }
            case 2004: {
                return Utils.convert(resultSet.getBlob(columnIndex), sqlType, ballerinaType);
            }
            case 2005: {
                String clobValue = Utils.getString(resultSet.getClob(columnIndex));
                return Utils.convert(clobValue, sqlType, ballerinaType);
            }
            case 2011: {
                String nClobValue = Utils.getString(resultSet.getNClob(columnIndex));
                return Utils.convert(nClobValue, sqlType, ballerinaType);
            }
            case 91: {
                Date date = resultSet.getDate(columnIndex, calendar);
                return Utils.convert(date, sqlType, ballerinaType);
            }
            case 92: 
            case 2013: {
                Time time = resultSet.getTime(columnIndex, calendar);
                return Utils.convert(time, sqlType, ballerinaType);
            }
            case 93: 
            case 2014: {
                Timestamp timestamp = resultSet.getTimestamp(columnIndex, calendar);
                return Utils.convert(timestamp, sqlType, ballerinaType);
            }
            case -8: {
                String rowId = new String(resultSet.getRowId(columnIndex).getBytes(), StandardCharsets.UTF_8);
                return Utils.convert(rowId, sqlType, ballerinaType);
            }
            case -6: 
            case 5: {
                long iValue = resultSet.getInt(columnIndex);
                return Utils.convert(iValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case -5: 
            case 4: {
                long lValue = resultSet.getLong(columnIndex);
                return Utils.convert(lValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 6: 
            case 7: {
                double fValue = resultSet.getFloat(columnIndex);
                return Utils.convert(fValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 8: {
                double dValue = resultSet.getDouble(columnIndex);
                return Utils.convert(dValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 2: 
            case 3: {
                BigDecimal decimalValue = resultSet.getBigDecimal(columnIndex);
                return Utils.convert(decimalValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case -7: 
            case 16: {
                boolean boolValue = resultSet.getBoolean(columnIndex);
                return Utils.convert(boolValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 2002: {
                Struct structData = (Struct)resultSet.getObject(columnIndex);
                return Utils.convert(structData, sqlType, ballerinaType);
            }
        }
        throw new ApplicationError("unsupported sql type " + sqlType + " found for the column index: " + columnIndex);
    }

    public static Object closeResult(ObjectValue recordIterator) {
        ResultSet resultSet = (ResultSet)recordIterator.getNativeData("ResultSet");
        Statement statement = (Statement)recordIterator.getNativeData("Statement");
        Connection connection = (Connection)recordIterator.getNativeData("Connection");
        if (resultSet != null) {
            try {
                resultSet.close();
                recordIterator.addNativeData("ResultSet", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the result set. ");
            }
        }
        if (statement != null) {
            try {
                statement.close();
                recordIterator.addNativeData("Statement", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the result set. ");
            }
        }
        if (connection != null) {
            try {
                connection.close();
                recordIterator.addNativeData("Connection", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the connection. ");
            }
        }
        return null;
    }
}

