/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.sql.exception.ApplicationError;
import org.ballerinalang.stdlib.time.util.TimeUtils;

class Utils {
    private static final BArrayType stringArrayType = new BArrayType(BTypes.typeString);
    private static final BArrayType booleanArrayType = new BArrayType(BTypes.typeBoolean);
    private static final BArrayType intArrayType = new BArrayType(BTypes.typeInt);
    private static final BArrayType floatArrayType = new BArrayType(BTypes.typeFloat);
    private static final BArrayType decimalArrayType = new BArrayType(BTypes.typeDecimal);

    Utils() {
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static ArrayValue convert(Array array, int sqlType, BType bType) throws SQLException, ApplicationError {
        if (array != null) {
            Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Array");
            Object[] dataArray = (Object[])array.getArray();
            if (dataArray == null || dataArray.length == 0) {
                return null;
            }
            Object[] result = Utils.validateNullable(dataArray);
            Object firstNonNullElement = result[0];
            boolean containsNull = (Boolean)result[1];
            if (containsNull) {
                return Utils.createAndPopulateRefValueArray(firstNonNullElement, dataArray, bType);
            }
            return Utils.createAndPopulatePrimitiveValueArray(firstNonNullElement, dataArray);
        }
        return null;
    }

    private static ArrayValue createAndPopulatePrimitiveValueArray(Object firstNonNullElement, Object[] dataArray) {
        int length = dataArray.length;
        if (firstNonNullElement instanceof String) {
            ArrayValue stringDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)stringArrayType);
            for (int i = 0; i < length; ++i) {
                stringDataArray.add((long)i, (String)dataArray[i]);
            }
            return stringDataArray;
        }
        if (firstNonNullElement instanceof Boolean) {
            ArrayValue boolDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)booleanArrayType);
            for (int i = 0; i < length; ++i) {
                boolDataArray.add((long)i, ((Boolean)dataArray[i]).booleanValue());
            }
            return boolDataArray;
        }
        if (firstNonNullElement instanceof Integer) {
            ArrayValue intDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)intArrayType);
            for (int i = 0; i < length; ++i) {
                intDataArray.add((long)i, (long)((Integer)dataArray[i]).intValue());
            }
            return intDataArray;
        }
        if (firstNonNullElement instanceof Long) {
            ArrayValue longDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)intArrayType);
            for (int i = 0; i < length; ++i) {
                longDataArray.add((long)i, ((Long)dataArray[i]).longValue());
            }
            return longDataArray;
        }
        if (firstNonNullElement instanceof Float) {
            ArrayValue floatDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)floatArrayType);
            for (int i = 0; i < length; ++i) {
                floatDataArray.add((long)i, (double)((Float)dataArray[i]).floatValue());
            }
            return floatDataArray;
        }
        if (firstNonNullElement instanceof Double) {
            ArrayValue doubleDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)floatArrayType);
            for (int i = 0; i < dataArray.length; ++i) {
                doubleDataArray.add((long)i, ((Double)dataArray[i]).doubleValue());
            }
            return doubleDataArray;
        }
        if (firstNonNullElement instanceof BigDecimal) {
            ArrayValue decimalDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)decimalArrayType);
            for (int i = 0; i < dataArray.length; ++i) {
                decimalDataArray.add((long)i, (Object)new DecimalValue((BigDecimal)dataArray[i]));
            }
            return decimalDataArray;
        }
        return null;
    }

    static String getString(Clob data) throws IOException, SQLException {
        if (data == null) {
            return null;
        }
        try (BufferedReader r = new BufferedReader(data.getCharacterStream());){
            int pos;
            StringBuilder sb = new StringBuilder();
            while ((pos = ((Reader)r).read()) != -1) {
                sb.append((char)pos);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static ArrayValue createAndPopulateRefValueArray(Object firstNonNullElement, Object[] dataArray, BType bType) {
        ArrayValue refValueArray;
        block9: {
            int length;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        refValueArray = null;
                                        length = dataArray.length;
                                        if (!(firstNonNullElement instanceof String)) break block8;
                                        refValueArray = Utils.createEmptyRefValueArray(BTypes.typeString);
                                        for (int i = 0; i < length; ++i) {
                                            refValueArray.add((long)i, dataArray[i]);
                                        }
                                        break block9;
                                    }
                                    if (!(firstNonNullElement instanceof Boolean)) break block10;
                                    refValueArray = Utils.createEmptyRefValueArray(BTypes.typeBoolean);
                                    for (int i = 0; i < length; ++i) {
                                        refValueArray.add((long)i, dataArray[i]);
                                    }
                                    break block9;
                                }
                                if (!(firstNonNullElement instanceof Integer)) break block11;
                                refValueArray = Utils.createEmptyRefValueArray(BTypes.typeInt);
                                for (int i = 0; i < length; ++i) {
                                    refValueArray.add((long)i, dataArray[i]);
                                }
                                break block9;
                            }
                            if (!(firstNonNullElement instanceof Long)) break block12;
                            refValueArray = Utils.createEmptyRefValueArray(BTypes.typeInt);
                            for (int i = 0; i < length; ++i) {
                                refValueArray.add((long)i, dataArray[i]);
                            }
                            break block9;
                        }
                        if (!(firstNonNullElement instanceof Float)) break block13;
                        refValueArray = Utils.createEmptyRefValueArray(BTypes.typeFloat);
                        for (int i = 0; i < length; ++i) {
                            refValueArray.add((long)i, dataArray[i]);
                        }
                        break block9;
                    }
                    if (!(firstNonNullElement instanceof Double)) break block14;
                    refValueArray = Utils.createEmptyRefValueArray(BTypes.typeFloat);
                    for (int i = 0; i < length; ++i) {
                        refValueArray.add((long)i, dataArray[i]);
                    }
                    break block9;
                }
                if (!(firstNonNullElement instanceof BigDecimal)) break block15;
                refValueArray = Utils.createEmptyRefValueArray(BTypes.typeDecimal);
                for (int i = 0; i < length; ++i) {
                    refValueArray.add((long)i, (Object)(dataArray[i] != null ? new DecimalValue((BigDecimal)dataArray[i]) : null));
                }
                break block9;
            }
            if (firstNonNullElement != null) break block9;
            refValueArray = Utils.createEmptyRefValueArray(bType);
            for (int i = 0; i < length; ++i) {
                refValueArray.add((long)i, firstNonNullElement);
            }
        }
        return refValueArray;
    }

    private static ArrayValue createEmptyRefValueArray(BType type) {
        ArrayList<BType> memberTypes = new ArrayList<BType>(2);
        memberTypes.add(type);
        memberTypes.add(BTypes.typeNull);
        BUnionType unionType = new BUnionType(memberTypes);
        return (ArrayValue)BValueCreator.createArrayValue((BArrayType)new BArrayType((BType)unionType));
    }

    private static Object[] validateNullable(Object[] objects) {
        Object[] returnResult = new Object[2];
        boolean foundNull = false;
        Object nonNullObject = null;
        for (Object object : objects) {
            if (object != null) {
                if (nonNullObject == null) {
                    nonNullObject = object;
                }
                if (!foundNull) continue;
                break;
            }
            foundNull = true;
            if (nonNullObject != null) break;
        }
        returnResult[0] = nonNullObject;
        returnResult[1] = foundNull;
        return returnResult;
    }

    static Object convert(String value, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL String");
        return value;
    }

    static Object convert(byte[] value, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Binary");
        if (value != null) {
            return BValueCreator.createArrayValue((byte[])value);
        }
        return null;
    }

    static Object convert(long value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL long or integer");
        if (isNull) {
            return null;
        }
        if (bType.getTag() == 5) {
            return String.valueOf(value);
        }
        return value;
    }

    static Object convert(double value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL double or float");
        if (isNull) {
            return null;
        }
        if (bType.getTag() == 5) {
            return String.valueOf(value);
        }
        return value;
    }

    static Object convert(BigDecimal value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL decimal or real");
        if (isNull) {
            return null;
        }
        if (bType.getTag() == 5) {
            return String.valueOf(value);
        }
        return new DecimalValue(value);
    }

    static Object convert(Blob value, int sqlType, BType bType) throws ApplicationError, SQLException {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Blob");
        if (value != null) {
            return BValueCreator.createArrayValue((byte[])value.getBytes(1L, (int)value.length()));
        }
        return null;
    }

    static Object convert(java.util.Date date, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Date/Time");
        if (date != null) {
            switch (bType.getTag()) {
                case 5: {
                    return Utils.getString(date);
                }
                case 12: 
                case 34: {
                    return Utils.createTimeStruct(date.getTime());
                }
                case 1: {
                    return date.getTime();
                }
            }
        }
        return null;
    }

    static Object convert(boolean value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Boolean");
        if (!isNull) {
            switch (bType.getTag()) {
                case 6: {
                    return value;
                }
                case 1: {
                    if (value) {
                        return 1L;
                    }
                    return 0L;
                }
                case 5: {
                    return String.valueOf(value);
                }
            }
        }
        return null;
    }

    static Object convert(Struct value, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Struct");
        if (value != null) {
            if (bType instanceof BRecordType) {
                return Utils.createUserDefinedType(value, (BStructureType)((BRecordType)bType));
            }
            throw new ApplicationError("The ballerina type that can be used for SQL struct should be record type, but found " + bType.getName() + " .");
        }
        return null;
    }

    private static MapValue<String, Object> createUserDefinedType(Struct structValue, BStructureType structType) throws ApplicationError {
        if (structValue == null) {
            return null;
        }
        BField[] internalStructFields = structType.getFields().values().toArray(new BField[0]);
        MapValueImpl struct = new MapValueImpl((BType)structType);
        try {
            Object[] dataArray = structValue.getAttributes();
            if (dataArray != null) {
                if (dataArray.length != internalStructFields.length) {
                    throw new ApplicationError("specified record and the returned SQL Struct field counts are different, and hence not compatible");
                }
                int index = 0;
                for (BField internalField : internalStructFields) {
                    int type = internalField.getFieldType().getTag();
                    String fieldName = internalField.getFieldName();
                    Object value = dataArray[index];
                    switch (type) {
                        case 1: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (Object)((BigDecimal)value).intValue());
                                break;
                            }
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 3: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (Object)((BigDecimal)value).doubleValue());
                                break;
                            }
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 4: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, value);
                                break;
                            }
                            struct.put((Object)fieldName, (Object)new DecimalValue((BigDecimal)value));
                            break;
                        }
                        case 5: {
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 6: {
                            struct.put((Object)fieldName, (Object)((Integer)value == 1 ? 1 : 0));
                            break;
                        }
                        case 12: 
                        case 34: {
                            struct.put((Object)fieldName, Utils.createUserDefinedType((Struct)value, (BStructureType)internalField.getFieldType()));
                            break;
                        }
                        default: {
                            throw new ApplicationError("Error while retrieving data for unsupported type " + internalField.getFieldType().getName() + " to create " + structType.getName() + " record.");
                        }
                    }
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            throw new ApplicationError("Error while retrieving data to create " + structType.getName() + " record. ", e);
        }
        return struct;
    }

    private static MapValue<String, Object> createTimeStruct(long millis) {
        return TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)millis, (String)"UTC");
    }

    private static String getString(java.util.Date value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(value);
        if (!calendar.isSet(15)) {
            calendar.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer datetimeString = new StringBuffer(28);
        if (value instanceof Date) {
            calendar.setTime(value);
            Utils.appendDate(datetimeString, calendar);
            Utils.appendTimeZone(calendar, datetimeString);
        } else if (value instanceof Time) {
            calendar.setTimeInMillis(value.getTime());
            Utils.appendTime(calendar, datetimeString);
            Utils.appendTimeZone(calendar, datetimeString);
        } else if (value instanceof Timestamp) {
            calendar.setTimeInMillis(value.getTime());
            Utils.appendDate(datetimeString, calendar);
            datetimeString.append("T");
            Utils.appendTime(calendar, datetimeString);
            Utils.appendTimeZone(calendar, datetimeString);
        } else {
            calendar.setTime(value);
            Utils.appendTime(calendar, datetimeString);
            Utils.appendTimeZone(calendar, datetimeString);
        }
        return datetimeString.toString();
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    private static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    private static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }

    private static void validatedInvalidFieldAssignment(int sqlType, BType bType, String sqlTypeName) throws ApplicationError {
        if (!Utils.isValidFieldConstraint(sqlType, bType)) {
            throw new ApplicationError(sqlTypeName + " field cannot be converted to ballerina type : " + bType.getName());
        }
    }

    public static BType validFieldConstraint(int sqlType, BType bType) {
        if (bType.getTag() == 21 && bType instanceof BUnionType) {
            BUnionType bUnionType = (BUnionType)bType;
            for (BType memberType : bUnionType.getMemberTypes()) {
                if (!Utils.isValidFieldConstraint(sqlType, memberType)) continue;
                return memberType;
            }
        } else if (Utils.isValidPrimitiveConstraint(sqlType, bType)) {
            return bType;
        }
        return null;
    }

    public static boolean isValidFieldConstraint(int sqlType, BType bType) {
        if (bType.getTag() == 21 && bType instanceof BUnionType) {
            BUnionType bUnionType = (BUnionType)bType;
            for (BType memberType : bUnionType.getMemberTypes()) {
                if (!Utils.isValidFieldConstraint(sqlType, memberType)) continue;
                return true;
            }
            return false;
        }
        return Utils.isValidPrimitiveConstraint(sqlType, bType);
    }

    private static boolean isValidPrimitiveConstraint(int sqlType, BType bType) {
        switch (sqlType) {
            case 2003: {
                return bType.getTag() == 20;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return bType.getTag() == 5 || bType.getTag() == 7;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return bType.getTag() == 5 || bType.getTag() == 34 || bType.getTag() == 12 || bType.getTag() == 1;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return bType.getTag() == 1 || bType.getTag() == 5;
            }
            case -7: 
            case 16: {
                return bType.getTag() == 6 || bType.getTag() == 1 || bType.getTag() == 5;
            }
            case 2: 
            case 3: {
                return bType.getTag() == 4 || bType.getTag() == 1 || bType.getTag() == 5;
            }
            case 6: 
            case 7: 
            case 8: {
                return bType.getTag() == 3 || bType.getTag() == 5;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (bType.getTag() == 20) {
                    int elementTypeTag = ((BArrayType)bType).getElementType().getTag();
                    return elementTypeTag == 2;
                }
                return bType.getTag() == 35;
            }
            case 2002: {
                return bType.getTag() == 12;
            }
        }
        return bType.getTag() == 17;
    }
}

