/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.datasource.PoolKey;
import org.ballerinalang.sql.datasource.SQLDatasourceUtils;
import org.ballerinalang.sql.utils.ErrorGenerator;

public class SQLDatasource {
    private HikariDataSource hikariDataSource;
    private AtomicInteger clientCounter = new AtomicInteger(0);
    private Lock mutex = new ReentrantLock();
    private boolean poolShutdown = false;
    private boolean xaConn;
    private XADataSource xaDataSource;

    private SQLDatasource(SQLDatasourceParams sqlDatasourceParams) {
        this.buildDataSource(sqlDatasourceParams);
        Connection connection = null;
        try {
            this.xaConn = this.hikariDataSource.isWrapperFor(XADataSource.class);
            if (this.xaConn) {
                this.xaDataSource = (XADataSource)this.hikariDataSource.unwrap(XADataSource.class);
                connection = this.xaDataSource.getXAConnection().getConnection();
            } else {
                connection = this.getConnection();
            }
        }
        catch (SQLException e) {
            throw ErrorGenerator.getSQLDatabaseError(e, "error while verifying the connection for SQLClientConnector, ");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLDatasource retrieveDatasource(SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource existingSqlDatasource;
        PoolKey poolKey = new PoolKey(sqlDatasourceParams.url, sqlDatasourceParams.options);
        Map<PoolKey, SQLDatasource> hikariDatasourceMap = SQLDatasourceUtils.retrieveDatasourceContainer((MapValue<BString, Object>)sqlDatasourceParams.connectionPool);
        if (hikariDatasourceMap == null) {
            hikariDatasourceMap = SQLDatasourceUtils.putDatasourceContainer((MapValue<BString, Object>)sqlDatasourceParams.connectionPool, new ConcurrentHashMap<PoolKey, SQLDatasource>());
        }
        SQLDatasource sqlDatasourceToBeReturned = existingSqlDatasource = hikariDatasourceMap.get(poolKey);
        if (existingSqlDatasource != null) {
            existingSqlDatasource.acquireMutex();
            try {
                if (!existingSqlDatasource.isPoolShutdown()) {
                    existingSqlDatasource.incrementClientCounter();
                }
                sqlDatasourceToBeReturned = hikariDatasourceMap.compute(poolKey, (key, value) -> SQLDatasource.createAndInitDatasource(sqlDatasourceParams));
            }
            finally {
                existingSqlDatasource.releaseMutex();
            }
        } else {
            sqlDatasourceToBeReturned = hikariDatasourceMap.computeIfAbsent(poolKey, key -> SQLDatasource.createAndInitDatasource(sqlDatasourceParams));
        }
        return sqlDatasourceToBeReturned;
    }

    private static SQLDatasource createAndInitDatasource(SQLDatasourceParams sqlDatasourceParams) {
        SQLDatasource newSqlDatasource = new SQLDatasource(sqlDatasourceParams);
        newSqlDatasource.incrementClientCounter();
        return newSqlDatasource;
    }

    Connection getConnection() throws SQLException {
        return this.hikariDataSource.getConnection();
    }

    public XAConnection getXAConnection() throws SQLException {
        if (this.isXADataSource()) {
            return this.xaDataSource.getXAConnection();
        }
        return null;
    }

    public boolean isXADataSource() {
        return this.xaConn;
    }

    private void closeConnectionPool() {
        this.hikariDataSource.close();
        this.poolShutdown = true;
    }

    private boolean isPoolShutdown() {
        return this.poolShutdown;
    }

    private void incrementClientCounter() {
        this.clientCounter.incrementAndGet();
    }

    public void decrementClientCounterAndAttemptPoolShutdown() {
        this.acquireMutex();
        if (!this.poolShutdown && this.clientCounter.decrementAndGet() == 0) {
            this.closeConnectionPool();
        }
        this.releaseMutex();
    }

    private void releaseMutex() {
        this.mutex.unlock();
    }

    private void acquireMutex() {
        this.mutex.lock();
    }

    private void buildDataSource(SQLDatasourceParams sqlDatasourceParams) {
        try {
            HikariConfig config = sqlDatasourceParams.poolProperties != null ? new HikariConfig(sqlDatasourceParams.poolProperties) : new HikariConfig();
            config.setJdbcUrl(sqlDatasourceParams.url);
            config.setUsername(sqlDatasourceParams.user);
            config.setPassword(sqlDatasourceParams.password);
            if (sqlDatasourceParams.datasourceName != null && !sqlDatasourceParams.datasourceName.isEmpty()) {
                if (sqlDatasourceParams.options == null || !sqlDatasourceParams.options.containsKey((Object)Constants.Options.URL)) {
                    config.addDataSourceProperty(Constants.Options.URL.getValue(), (Object)sqlDatasourceParams.url);
                }
                if (sqlDatasourceParams.user != null) {
                    config.addDataSourceProperty("user", (Object)sqlDatasourceParams.user);
                }
                if (sqlDatasourceParams.password != null) {
                    config.addDataSourceProperty("password", (Object)sqlDatasourceParams.password);
                }
            }
            config.setDataSourceClassName(sqlDatasourceParams.datasourceName);
            if (sqlDatasourceParams.connectionPool != null) {
                int minIdleConnections;
                DecimalValue connLifeTime;
                Object connLifeTimeSec;
                int maxOpenConn = sqlDatasourceParams.connectionPool.getIntValue(Constants.ConnectionPool.MAX_OPEN_CONNECTIONS).intValue();
                if (maxOpenConn > 0) {
                    config.setMaximumPoolSize(maxOpenConn);
                }
                if ((connLifeTimeSec = sqlDatasourceParams.connectionPool.get((Object)Constants.ConnectionPool.MAX_CONNECTION_LIFE_TIME_SECONDS)) instanceof DecimalValue && (connLifeTime = (DecimalValue)connLifeTimeSec).floatValue() > 0.0) {
                    long connLifeTimeMS = Double.valueOf(connLifeTime.floatValue() * 1000.0).longValue();
                    config.setMaxLifetime(connLifeTimeMS);
                }
                if ((minIdleConnections = sqlDatasourceParams.connectionPool.getIntValue(Constants.ConnectionPool.MIN_IDLE_CONNECTIONS).intValue()) > 0) {
                    config.setMinimumIdle(minIdleConnections);
                }
            }
            if (sqlDatasourceParams.options != null) {
                MapValue optionMap = sqlDatasourceParams.options;
                optionMap.entrySet().forEach(entry -> {
                    if (!SQLDatasourceUtils.isSupportedDbOptionType(entry.getValue())) {
                        throw ErrorGenerator.getSQLApplicationError("unsupported type " + entry.getKey() + " for the db option");
                    }
                    config.addDataSourceProperty(((BString)entry.getKey()).getValue(), entry.getValue());
                });
            }
            this.hikariDataSource = new HikariDataSource(config);
            Runtime.getRuntime().addShutdownHook(new Thread(this::closeConnectionPool));
        }
        catch (Throwable t) {
            StringBuilder message = new StringBuilder("error in sql connector configuration: " + t.getMessage() + "");
            String lastCauseMessage = null;
            int count = 0;
            while (t.getCause() != null && count < 3) {
                lastCauseMessage = t.getCause().getMessage();
                message.append(" Caused by :").append(lastCauseMessage);
                ++count;
                t = t.getCause();
            }
            throw ErrorGenerator.getSQLApplicationError(message.toString());
        }
    }

    public static class SQLDatasourceParams {
        private String url;
        private String user;
        private String password;
        private String datasourceName;
        private MapValue connectionPool;
        private MapValue options;
        private Properties poolProperties;

        public SQLDatasourceParams setConnectionPool(MapValue connectionPool, MapValue globalConnectionPool) {
            this.connectionPool = connectionPool != null ? connectionPool : globalConnectionPool;
            return this;
        }

        public SQLDatasourceParams setUrl(String url) {
            this.url = url;
            return this;
        }

        public SQLDatasourceParams setUser(String user) {
            this.user = user;
            return this;
        }

        public SQLDatasourceParams setPassword(String password) {
            this.password = password;
            return this;
        }

        public SQLDatasourceParams setDatasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        public SQLDatasourceParams setOptions(MapValue options) {
            this.options = options;
            return this;
        }

        public SQLDatasourceParams setPoolProperties(Properties properties) {
            this.poolProperties = properties;
            return this;
        }
    }
}

