/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.BallerinaTransactionContext;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.transactions.TransactionResourceManager;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.sql.datasource.PoolKey;
import org.ballerinalang.sql.datasource.SQLDatasource;
import org.ballerinalang.sql.transaction.SQLTransactionContext;

public class SQLDatasourceUtils {
    private static final String POOL_MAP_KEY = UUID.randomUUID().toString();

    static Map<PoolKey, SQLDatasource> retrieveDatasourceContainer(MapValue<BString, Object> poolOptions) {
        return (ConcurrentHashMap)poolOptions.getNativeData(POOL_MAP_KEY);
    }

    public static synchronized Map<PoolKey, SQLDatasource> putDatasourceContainer(MapValue<BString, Object> poolOptions, ConcurrentHashMap<PoolKey, SQLDatasource> datasourceMap) {
        Map existingDataSourceMap = (Map)poolOptions.getNativeData(POOL_MAP_KEY);
        if (existingDataSourceMap != null) {
            return existingDataSourceMap;
        }
        poolOptions.addNativeData(POOL_MAP_KEY, datasourceMap);
        return datasourceMap;
    }

    static boolean isSupportedDbOptionType(Object value) {
        boolean supported = false;
        if (value != null) {
            BType type = TypeChecker.getType((Object)value);
            int typeTag = type.getTag();
            supported = typeTag == 5 || typeTag == 1 || typeTag == 3 || typeTag == 6 || typeTag == 4 || typeTag == 2;
        }
        return supported;
    }

    public static Connection getConnection(Strand strand, ObjectValue client, SQLDatasource datasource) throws SQLException {
        Connection conn;
        try {
            boolean isInTransaction = strand.isInTransaction();
            if (!isInTransaction) {
                Connection conn2 = datasource.getConnection();
                return conn2;
            }
            if (!strand.transactionLocalContext.hasTransactionBlock()) {
                Connection conn3 = datasource.getConnection();
                return conn3;
            }
            String connectorId = (String)client.getNativeData("sql-transaction-id");
            boolean isXAConnection = datasource.isXADataSource();
            TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
            String globalTxId = transactionLocalContext.getGlobalTransactionId();
            String currentTxBlockId = transactionLocalContext.getCurrentTransactionBlockId();
            BallerinaTransactionContext txContext = transactionLocalContext.getTransactionContext(connectorId);
            if (txContext == null) {
                if (isXAConnection) {
                    XAConnection xaConn = datasource.getXAConnection();
                    XAResource xaResource = xaConn.getXAResource();
                    TransactionResourceManager.getInstance().beginXATransaction(globalTxId, currentTxBlockId, xaResource);
                    conn = xaConn.getConnection();
                    txContext = new SQLTransactionContext(conn, xaResource);
                } else {
                    conn = datasource.getConnection();
                    conn.setAutoCommit(false);
                    txContext = new SQLTransactionContext(conn);
                }
                transactionLocalContext.registerTransactionContext(connectorId, txContext);
                TransactionResourceManager.getInstance().register(globalTxId, currentTxBlockId, txContext);
            } else {
                conn = ((SQLTransactionContext)txContext).getConnection();
            }
        }
        catch (SQLException e) {
            throw new SQLException("error while getting the connection for SQLClientConnector. " + e.getMessage(), e.getSQLState(), e.getErrorCode());
        }
        return conn;
    }
}

