/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.util.Properties;
import java.util.UUID;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.datasource.SQLDatasource;

public class ClientUtils {
    private ClientUtils() {
    }

    public static Object createClient(ObjectValue client, SQLDatasource.SQLDatasourceParams sqlDatasourceParams) {
        try {
            SQLDatasource sqlDatasource = SQLDatasource.retrieveDatasource(sqlDatasourceParams);
            client.addNativeData("Client", (Object)sqlDatasource);
            client.addNativeData("sql-transaction-id", (Object)UUID.randomUUID().toString());
            return null;
        }
        catch (ErrorValue errorValue) {
            return errorValue;
        }
    }

    public static Object createSqlClient(ObjectValue client, MapValue<BString, Object> sqlDatasourceParams, MapValue<BString, Object> globalConnectionPool) {
        return ClientUtils.createClient(client, ClientUtils.createSQLDatasourceParams(sqlDatasourceParams, globalConnectionPool));
    }

    public static Object close(ObjectValue client) {
        Object datasourceObj = client.getNativeData("Client");
        if (datasourceObj != null) {
            ((SQLDatasource)datasourceObj).decrementClientCounterAndAttemptPoolShutdown();
        }
        return null;
    }

    private static SQLDatasource.SQLDatasourceParams createSQLDatasourceParams(MapValue<BString, Object> sqlDatasourceParams, MapValue<BString, Object> globalConnectionPool) {
        BString userVal;
        MapValue connPoolProps = sqlDatasourceParams.getMapValue(Constants.SQLParamsFields.CONNECTION_POOL_OPTIONS);
        Properties poolProperties = null;
        if (connPoolProps != null) {
            poolProperties = new Properties();
            for (BString key : (BString[])connPoolProps.getKeys()) {
                poolProperties.setProperty(key.getValue(), connPoolProps.getStringValue(key).getValue());
            }
        }
        String user = (userVal = sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.USER)) == null ? null : userVal.getValue();
        BString passwordVal = sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.PASSWORD);
        String password = passwordVal == null ? null : passwordVal.getValue();
        BString dataSourceNamVal = sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.DATASOURCE_NAME);
        String datasourceName = dataSourceNamVal == null ? null : dataSourceNamVal.getValue();
        return new SQLDatasource.SQLDatasourceParams().setUrl(sqlDatasourceParams.getStringValue(Constants.SQLParamsFields.URL).getValue()).setUser(user).setPassword(password).setDatasourceName(datasourceName).setOptions(sqlDatasourceParams.getMapValue(Constants.SQLParamsFields.OPTIONS)).setConnectionPool(sqlDatasourceParams.getMapValue(Constants.SQLParamsFields.CONNECTION_POOL), globalConnectionPool).setPoolProperties(poolProperties);
    }
}

