/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.sql.Constants;

public class ErrorGenerator {
    private ErrorGenerator() {
    }

    public static ErrorValue getSQLBatchExecuteError(SQLException exception, List<MapValue<BString, Object>> executionResults, String messagePrefix) {
        String sqlErrorMessage = exception.getMessage() != null ? exception.getMessage() : "Error occurred when batch executing commands.";
        int vendorCode = exception.getErrorCode();
        String sqlState = exception.getSQLState();
        String errorMessage = messagePrefix + sqlErrorMessage + ".";
        return ErrorGenerator.getSQLBatchExecuteError(errorMessage, vendorCode, sqlState, executionResults);
    }

    public static ErrorValue getSQLDatabaseError(SQLException exception, String messagePrefix) {
        String sqlErrorMessage = exception.getMessage() != null ? exception.getMessage() : "Database Error Occurred";
        int vendorCode = exception.getErrorCode();
        String sqlState = exception.getSQLState();
        String errorMessage = messagePrefix + sqlErrorMessage + ".";
        return ErrorGenerator.getSQLDatabaseError(errorMessage, vendorCode, sqlState);
    }

    public static ErrorValue getSQLApplicationError(String errorMessage) {
        return BallerinaErrors.createDistinctError((String)"ApplicationError", (BPackage)Constants.SQL_PACKAGE_ID, (String)errorMessage);
    }

    private static ErrorValue getSQLBatchExecuteError(String message, int vendorCode, String sqlState, List<MapValue<BString, Object>> executionResults) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("errorCode", vendorCode);
        valueMap.put("sqlState", sqlState);
        valueMap.put("executionResults", BValueCreator.createArrayValue((Object[])executionResults.toArray(), (BArrayType)new BArrayType((BType)new BRecordType("ExecutionResult", Constants.SQL_PACKAGE_ID, 0, false, 0))));
        MapValue sqlClientErrorDetailRecord = BallerinaValues.createRecordValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"BatchExecuteErrorDetail", valueMap);
        return BallerinaErrors.createDistinctError((String)"BatchExecuteError", (BPackage)Constants.SQL_PACKAGE_ID, (String)message, (MapValue)sqlClientErrorDetailRecord);
    }

    private static ErrorValue getSQLDatabaseError(String message, int vendorCode, String sqlState) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("errorCode", vendorCode);
        valueMap.put("sqlState", sqlState);
        MapValue sqlClientErrorDetailRecord = BallerinaValues.createRecordValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"DatabaseErrorDetail", valueMap);
        return BallerinaErrors.createDistinctError((String)"DatabaseError", (BPackage)Constants.SQL_PACKAGE_ID, (String)message, (MapValue)sqlClientErrorDetailRecord);
    }
}

