/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.AbstractObjectValue;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.datasource.SQLDatasource;
import org.ballerinalang.sql.datasource.SQLDatasourceUtils;
import org.ballerinalang.sql.exception.ApplicationError;
import org.ballerinalang.sql.utils.ErrorGenerator;
import org.ballerinalang.sql.utils.Utils;

public class ExecuteUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object nativeExecute(ObjectValue client, Object paramSQLString) {
        Object dbClient = client.getNativeData("Client");
        Strand strand = Scheduler.getStrand();
        if (dbClient != null) {
            MapValue mapValue;
            SQLDatasource sqlDatasource = (SQLDatasource)dbClient;
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet resultSet = null;
            String sqlQuery = null;
            try {
                sqlQuery = paramSQLString instanceof StringValue ? ((StringValue)paramSQLString).getValue() : Utils.getSqlQuery((AbstractObjectValue)paramSQLString);
                connection = SQLDatasourceUtils.getConnection(strand, client, sqlDatasource);
                statement = connection.prepareStatement(sqlQuery, 1);
                if (paramSQLString instanceof AbstractObjectValue) {
                    Utils.setParams(connection, statement, (AbstractObjectValue)paramSQLString);
                }
                int count = statement.executeUpdate();
                Object lastInsertedId = null;
                if (!ExecuteUtils.isDdlStatement(sqlQuery) && (resultSet = statement.getGeneratedKeys()).next()) {
                    lastInsertedId = ExecuteUtils.getGeneratedKeys(resultSet);
                }
                HashMap<String, Object> resultFields = new HashMap<String, Object>();
                resultFields.put("affectedRowCount", count);
                resultFields.put("lastInsertId", lastInsertedId);
                mapValue = BallerinaValues.createRecordValue((BPackage)Constants.SQL_PACKAGE_ID, (String)"ExecutionResult", resultFields);
            }
            catch (SQLException e) {
                ErrorValue errorValue = ErrorGenerator.getSQLDatabaseError(e, "Error while executing sql query: " + sqlQuery + ". ");
                Utils.closeResources(strand, resultSet, statement, connection);
                return errorValue;
            }
            catch (IOException | ApplicationError e2) {
                ErrorValue errorValue = ErrorGenerator.getSQLApplicationError("Error while executing sql query: " + sqlQuery + ". " + e2.getMessage());
                {
                    catch (Throwable throwable) {
                        Utils.closeResources(strand, resultSet, statement, connection);
                        throw throwable;
                    }
                }
                Utils.closeResources(strand, resultSet, statement, connection);
                return errorValue;
            }
            Utils.closeResources(strand, resultSet, statement, connection);
            return mapValue;
        }
        return ErrorGenerator.getSQLApplicationError("Client is not properly initialized!");
    }

    /*
     * Exception decompiling
     */
    public static Object nativeBatchExecute(ObjectValue client, ArrayValue paramSQLStrings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object getGeneratedKeys(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (columnCount > 0) {
            int sqlType = metaData.getColumnType(1);
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 16: {
                    return rs.getLong(1);
                }
            }
            return rs.getString(1);
        }
        return null;
    }

    private static boolean isDdlStatement(String query) {
        String upperCaseQuery = query.trim().toUpperCase(Locale.ENGLISH);
        return Arrays.stream(DdlKeyword.values()).anyMatch(ddlKeyword -> upperCaseQuery.startsWith(ddlKeyword.name()));
    }

    private static enum DdlKeyword {
        CREATE,
        ALTER,
        DROP,
        TRUNCATE,
        COMMENT,
        RENAME;

    }
}

