/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.exception.ApplicationError;
import org.ballerinalang.sql.utils.ColumnDefinition;
import org.ballerinalang.sql.utils.ErrorGenerator;
import org.ballerinalang.sql.utils.Utils;

public class RecordItertorUtils {
    private static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(Constants.TIMEZONE_UTC.getValue()));

    public static Object nextResult(ObjectValue recordIterator) {
        ResultSet resultSet = (ResultSet)recordIterator.getNativeData("ResultSet");
        try {
            if (resultSet.next()) {
                BStructureType streamConstraint = (BStructureType)recordIterator.getNativeData("recordType");
                MapValueImpl bStruct = new MapValueImpl((BType)streamConstraint);
                List columnDefinitions = (List)recordIterator.getNativeData("ColumnDefinition");
                for (int i = 0; i < columnDefinitions.size(); ++i) {
                    ColumnDefinition columnDefinition = (ColumnDefinition)columnDefinitions.get(i);
                    bStruct.put((Object)StringUtils.fromString((String)columnDefinition.getBallerinaFieldName()), RecordItertorUtils.getResult(resultSet, i + 1, columnDefinition));
                }
                return bStruct;
            }
            return null;
        }
        catch (SQLException e) {
            return ErrorGenerator.getSQLDatabaseError(e, "Error when iterating the SQL result");
        }
        catch (IOException | ApplicationError e) {
            return ErrorGenerator.getSQLApplicationError("Error when iterating the SQL result. " + e.getMessage());
        }
        catch (Throwable throwable) {
            return ErrorGenerator.getSQLApplicationError("Error when iterating through the SQL result. " + throwable.getMessage());
        }
    }

    private static Object getResult(ResultSet resultSet, int columnIndex, ColumnDefinition columnDefinition) throws SQLException, ApplicationError, IOException {
        int sqlType = columnDefinition.getSqlType();
        BType ballerinaType = columnDefinition.getBallerinaType();
        switch (sqlType) {
            case 2003: {
                return Utils.convert(resultSet.getArray(columnIndex), sqlType, ballerinaType);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return Utils.convert(resultSet.getString(columnIndex), sqlType, ballerinaType);
            }
            case -4: 
            case -3: 
            case -2: {
                if (ballerinaType.getTag() == 5) {
                    return Utils.convert(resultSet.getString(columnIndex), sqlType, ballerinaType, columnDefinition.getSqlName());
                }
                return Utils.convert(resultSet.getBytes(columnIndex), sqlType, ballerinaType, columnDefinition.getSqlName());
            }
            case 2004: {
                return Utils.convert(resultSet.getBlob(columnIndex), sqlType, ballerinaType);
            }
            case 2005: {
                String clobValue = Utils.getString(resultSet.getClob(columnIndex));
                return Utils.convert(clobValue, sqlType, ballerinaType);
            }
            case 2011: {
                String nClobValue = Utils.getString(resultSet.getNClob(columnIndex));
                return Utils.convert(nClobValue, sqlType, ballerinaType);
            }
            case 91: {
                Date date = resultSet.getDate(columnIndex, calendar);
                return Utils.convert(date, sqlType, ballerinaType);
            }
            case 92: {
                Time time = resultSet.getTime(columnIndex, calendar);
                return Utils.convert(time, sqlType, ballerinaType);
            }
            case 2013: {
                try {
                    Time time = resultSet.getTime(columnIndex, calendar);
                    return Utils.convert(time, sqlType, ballerinaType);
                }
                catch (SQLException ex) {
                    OffsetTime offsetTime = resultSet.getObject(columnIndex, OffsetTime.class);
                    return Utils.convert(Time.valueOf(offsetTime.toLocalTime()), sqlType, ballerinaType);
                }
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(columnIndex, calendar);
                return Utils.convert(timestamp, sqlType, ballerinaType);
            }
            case 2014: {
                try {
                    Timestamp timestamp = resultSet.getTimestamp(columnIndex, calendar);
                    return Utils.convert(timestamp, sqlType, ballerinaType);
                }
                catch (SQLException ex) {
                    OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
                    return Utils.convert(Timestamp.valueOf(offsetDateTime.toLocalDateTime()), sqlType, ballerinaType);
                }
            }
            case -8: {
                return Utils.convert(resultSet.getRowId(columnIndex).getBytes(), sqlType, ballerinaType, "SQL RowID");
            }
            case -6: 
            case 5: {
                long iValue = resultSet.getInt(columnIndex);
                return Utils.convert(iValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case -5: 
            case 4: {
                long lValue = resultSet.getLong(columnIndex);
                return Utils.convert(lValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 6: 
            case 7: {
                double fValue = resultSet.getFloat(columnIndex);
                return Utils.convert(fValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 8: {
                double dValue = resultSet.getDouble(columnIndex);
                return Utils.convert(dValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 2: 
            case 3: {
                BigDecimal decimalValue = resultSet.getBigDecimal(columnIndex);
                return Utils.convert(decimalValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case -7: 
            case 16: {
                boolean boolValue = resultSet.getBoolean(columnIndex);
                return Utils.convert(boolValue, sqlType, ballerinaType, resultSet.wasNull());
            }
            case 2002: 
            case 2006: {
                Struct structData = (Struct)resultSet.getObject(columnIndex);
                return Utils.convert(structData, sqlType, ballerinaType);
            }
            case 2009: {
                SQLXML sqlxml = resultSet.getSQLXML(columnIndex);
                return Utils.convert(sqlxml, sqlType, ballerinaType);
            }
        }
        if (ballerinaType.getTag() == 1) {
            Utils.convert(resultSet.getInt(columnIndex), sqlType, ballerinaType, resultSet.wasNull());
        } else {
            if (ballerinaType.getTag() == 5 || ballerinaType.getTag() == 17 || ballerinaType.getTag() == 11) {
                return Utils.convert(resultSet.getString(columnIndex), sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 6) {
                return Utils.convert(resultSet.getBoolean(columnIndex), sqlType, ballerinaType, resultSet.wasNull());
            }
            if (ballerinaType.getTag() == 20 && ((BArrayType)ballerinaType).getElementType().getTag() == 2) {
                return Utils.convert(resultSet.getBytes(columnIndex), sqlType, ballerinaType, columnDefinition.getSqlName());
            }
            if (ballerinaType.getTag() == 3) {
                return Utils.convert(resultSet.getDouble(columnIndex), sqlType, ballerinaType, resultSet.wasNull());
            }
            if (ballerinaType.getTag() == 4) {
                return Utils.convert(resultSet.getBigDecimal(columnIndex), sqlType, ballerinaType, resultSet.wasNull());
            }
            if (ballerinaType.getTag() == 8) {
                return Utils.convert(resultSet.getSQLXML(columnIndex), sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 7) {
                String jsonString = Utils.convert(resultSet.getString(columnIndex), sqlType, ballerinaType).getValue();
                StringReader reader = new StringReader(jsonString);
                try {
                    return JSONParser.parse((Reader)reader);
                }
                catch (BallerinaException e) {
                    throw new ApplicationError("Error while converting to JSON type. " + e.getDetail());
                }
            }
        }
        throw new ApplicationError("unsupported sql type " + columnDefinition.getSqlName());
    }

    public static Object closeResult(ObjectValue recordIterator) {
        ResultSet resultSet = (ResultSet)recordIterator.getNativeData("ResultSet");
        Statement statement = (Statement)recordIterator.getNativeData("Statement");
        Connection connection = (Connection)recordIterator.getNativeData("Connection");
        if (resultSet != null) {
            try {
                resultSet.close();
                recordIterator.addNativeData("ResultSet", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the result set. ");
            }
        }
        if (statement != null) {
            try {
                statement.close();
                recordIterator.addNativeData("Statement", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the result set. ");
            }
        }
        if (connection != null) {
            try {
                connection.close();
                recordIterator.addNativeData("Connection", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the connection. ");
            }
        }
        return null;
    }
}

