/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.sql.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.types.BXMLType;
import org.ballerinalang.jvm.values.AbstractObjectValue;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.sql.Constants;
import org.ballerinalang.sql.exception.ApplicationError;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.readers.CharacterChannelReader;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.ballerinalang.stdlib.time.util.TimeUtils;

class Utils {
    private static final BArrayType stringArrayType = new BArrayType(BTypes.typeString);
    private static final BArrayType booleanArrayType = new BArrayType(BTypes.typeBoolean);
    private static final BArrayType intArrayType = new BArrayType(BTypes.typeInt);
    private static final BArrayType floatArrayType = new BArrayType(BTypes.typeFloat);
    private static final BArrayType decimalArrayType = new BArrayType(BTypes.typeDecimal);

    Utils() {
    }

    static void closeResources(Strand strand, ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!(strand != null && strand.isInTransaction() && strand.transactionLocalContext.hasTransactionBlock() || connection == null)) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static String getSqlQuery(AbstractObjectValue paramString) {
        ArrayValue stringsArray = paramString.getArrayValue(Constants.ParameterizedQueryFields.STRINGS);
        StringBuilder sqlQuery = new StringBuilder();
        for (int i = 0; i < stringsArray.size(); ++i) {
            if (i > 0) {
                sqlQuery.append(" ? ");
            }
            sqlQuery.append(stringsArray.get((long)i).toString());
        }
        return sqlQuery.toString();
    }

    static void setParams(Connection connection, PreparedStatement preparedStatement, AbstractObjectValue paramString) throws SQLException, ApplicationError, IOException {
        ArrayValue arrayValue = paramString.getArrayValue(Constants.ParameterizedQueryFields.INSERTIONS);
        for (int i = 0; i < arrayValue.size(); ++i) {
            Object object = arrayValue.get((long)i);
            int index = i + 1;
            if (object == null) {
                preparedStatement.setNull(index, 0);
                continue;
            }
            if (object instanceof BString) {
                preparedStatement.setString(index, object.toString());
                continue;
            }
            if (object instanceof Long) {
                preparedStatement.setLong(index, (Long)object);
                continue;
            }
            if (object instanceof Double) {
                preparedStatement.setDouble(index, (Double)object);
                continue;
            }
            if (object instanceof DecimalValue) {
                preparedStatement.setBigDecimal(index, ((DecimalValue)object).decimalValue());
                continue;
            }
            if (object instanceof Boolean) {
                preparedStatement.setBoolean(index, (Boolean)object);
                continue;
            }
            if (object instanceof ArrayValue) {
                ArrayValue objectArray = (ArrayValue)object;
                if (objectArray.getElementType().getTag() == 2) {
                    preparedStatement.setBytes(index, objectArray.getBytes());
                    continue;
                }
                throw new ApplicationError("Only byte[] is supported can be set directly into ParameterizedQuery, any other array types should be wrapped as sql:Value");
            }
            if (object instanceof ObjectValue) {
                ObjectValue objectValue = (ObjectValue)object;
                if (objectValue.getType().getTag() == 35) {
                    Utils.setSqlTypedParam(connection, preparedStatement, index, objectValue);
                    continue;
                }
                throw new ApplicationError("Unsupported type:" + objectValue.getType().getQualifiedName() + " in column index: " + index);
            }
            if (object instanceof XMLValue) {
                preparedStatement.setObject(index, (Object)((XMLValue)object).getTextValue(), 2009);
                continue;
            }
            throw new ApplicationError("Unsupported type passed in column index: " + index);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setSqlTypedParam(Connection connection, PreparedStatement preparedStatement, int index, ObjectValue typedValue) throws SQLException, ApplicationError, IOException {
        String sqlType = typedValue.getType().getName();
        Object value = typedValue.get(Constants.TypedValueFields.VALUE);
        switch (sqlType) {
            case "VarcharValue": 
            case "CharValue": 
            case "TextValue": {
                if (value == null) {
                    preparedStatement.setString(index, null);
                    return;
                }
                preparedStatement.setString(index, value.toString());
                return;
            }
            case "NCharValue": 
            case "NVarcharValue": {
                if (value == null) {
                    preparedStatement.setNString(index, null);
                    return;
                }
                preparedStatement.setNString(index, value.toString());
                return;
            }
            case "BitValue": 
            case "BooleanValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 16);
                    return;
                }
                if (value instanceof BString) {
                    preparedStatement.setBoolean(index, Boolean.parseBoolean(value.toString()));
                    return;
                }
                if (value instanceof Integer || value instanceof Long) {
                    long lVal = ((Number)value).longValue();
                    if (lVal != 1L && lVal != 0L) throw new ApplicationError("Only 1 or 0 can be passed for " + sqlType + " SQL Type, but found :" + lVal);
                    preparedStatement.setBoolean(index, lVal == 1L);
                    return;
                }
                if (!(value instanceof Boolean)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setBoolean(index, (Boolean)value);
                return;
            }
            case "IntegerValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 4);
                    return;
                }
                if (!(value instanceof Integer) && !(value instanceof Long)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setInt(index, ((Number)value).intValue());
                return;
            }
            case "BigIntValue": {
                if (value == null) {
                    preparedStatement.setNull(index, -5);
                    return;
                }
                if (!(value instanceof Integer) && !(value instanceof Long)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setLong(index, ((Number)value).longValue());
                return;
            }
            case "SmallIntValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 5);
                    return;
                }
                if (!(value instanceof Integer) && !(value instanceof Long)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setShort(index, ((Number)value).shortValue());
                return;
            }
            case "FloatValue": 
            case "RealValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 6);
                    return;
                }
                if (value instanceof Double || value instanceof Long || value instanceof Float || value instanceof Integer) {
                    preparedStatement.setFloat(index, ((Number)value).floatValue());
                    return;
                }
                if (!(value instanceof DecimalValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setFloat(index, ((DecimalValue)value).decimalValue().floatValue());
                return;
            }
            case "DoubleValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 8);
                    return;
                }
                if (value instanceof Double || value instanceof Long || value instanceof Float || value instanceof Integer) {
                    preparedStatement.setDouble(index, ((Number)value).doubleValue());
                    return;
                }
                if (!(value instanceof DecimalValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setDouble(index, ((DecimalValue)value).decimalValue().doubleValue());
                return;
            }
            case "NumericValue": 
            case "DecimalValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 3);
                    return;
                }
                if (value instanceof Double || value instanceof Long) {
                    preparedStatement.setBigDecimal(index, new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL64));
                    return;
                }
                if (value instanceof Integer || value instanceof Float) {
                    preparedStatement.setBigDecimal(index, new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL32));
                    return;
                }
                if (!(value instanceof DecimalValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                preparedStatement.setBigDecimal(index, ((DecimalValue)value).decimalValue());
                return;
            }
            case "BinaryValue": 
            case "VarBinaryValue": 
            case "BlobValue": {
                if (value == null) {
                    preparedStatement.setBytes(index, null);
                    return;
                }
                if (value instanceof ArrayValue) {
                    ArrayValue arrayValue = (ArrayValue)value;
                    if (arrayValue.getElementType().getTag() != 2) throw Utils.throwInvalidParameterError(value, sqlType);
                    preparedStatement.setBytes(index, arrayValue.getBytes());
                    return;
                }
                if (!(value instanceof ObjectValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                ObjectValue objectValue = (ObjectValue)value;
                if (!objectValue.getType().getName().equalsIgnoreCase("ReadableByteChannel") || !objectValue.getType().getPackage().toString().equalsIgnoreCase(IOConstants.IO_PACKAGE_ID.toString())) throw Utils.throwInvalidParameterError(value, sqlType);
                Channel byteChannel = (Channel)objectValue.getNativeData("byteChannel");
                preparedStatement.setBinaryStream(index, byteChannel.getInputStream());
                return;
            }
            case "ClobValue": 
            case "NClobValue": {
                if (value == null) {
                    preparedStatement.setNull(index, 2005);
                    return;
                }
                Clob clob = sqlType.equalsIgnoreCase("NClobValue") ? connection.createNClob() : connection.createClob();
                if (value instanceof BString) {
                    clob.setString(1L, value.toString());
                    preparedStatement.setClob(index, clob);
                    return;
                }
                if (!(value instanceof ObjectValue)) return;
                ObjectValue objectValue = (ObjectValue)value;
                if (!objectValue.getType().getName().equalsIgnoreCase("ReadableCharacterChannel") || !objectValue.getType().getPackage().toString().equalsIgnoreCase(IOConstants.IO_PACKAGE_ID.toString())) throw Utils.throwInvalidParameterError(value, sqlType);
                CharacterChannel charChannel = (CharacterChannel)objectValue.getNativeData("char_channel");
                preparedStatement.setCharacterStream(index, (Reader)new CharacterChannelReader(charChannel));
                return;
            }
            case "DateValue": {
                Date date;
                if (value == null) {
                    preparedStatement.setDate(index, null);
                    return;
                }
                if (value instanceof BString) {
                    date = Date.valueOf(value.toString());
                } else if (value instanceof Long) {
                    date = new Date((Long)value);
                } else {
                    if (!(value instanceof MapValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                    MapValue dateTimeStruct = (MapValue)value;
                    if (!dateTimeStruct.getType().getName().equalsIgnoreCase("Time")) throw Utils.throwInvalidParameterError(value, sqlType);
                    ZonedDateTime zonedDateTime = TimeUtils.getZonedDateTime((MapValue)dateTimeStruct);
                    date = new Date(zonedDateTime.toInstant().toEpochMilli());
                }
                preparedStatement.setDate(index, date);
                return;
            }
            case "TimeValue": {
                Time time;
                if (value == null) {
                    preparedStatement.setTime(index, null);
                    return;
                }
                if (value instanceof BString) {
                    time = Time.valueOf(value.toString());
                } else if (value instanceof Long) {
                    time = new Time((Long)value);
                } else {
                    if (!(value instanceof MapValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                    MapValue dateTimeStruct = (MapValue)value;
                    if (!dateTimeStruct.getType().getName().equalsIgnoreCase("Time")) throw Utils.throwInvalidParameterError(value, sqlType);
                    ZonedDateTime zonedDateTime = TimeUtils.getZonedDateTime((MapValue)dateTimeStruct);
                    time = new Time(zonedDateTime.toInstant().toEpochMilli());
                }
                preparedStatement.setTime(index, time);
                return;
            }
            case "TimestampValue": 
            case "DateTimeValue": {
                Timestamp timestamp;
                if (value == null) {
                    preparedStatement.setTimestamp(index, null);
                    return;
                }
                if (value instanceof BString) {
                    timestamp = Timestamp.valueOf(value.toString());
                } else if (value instanceof Long) {
                    timestamp = new Timestamp((Long)value);
                } else {
                    if (!(value instanceof MapValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                    MapValue dateTimeStruct = (MapValue)value;
                    if (!dateTimeStruct.getType().getName().equalsIgnoreCase("Time")) throw Utils.throwInvalidParameterError(value, sqlType);
                    ZonedDateTime zonedDateTime = TimeUtils.getZonedDateTime((MapValue)dateTimeStruct);
                    timestamp = new Timestamp(zonedDateTime.toInstant().toEpochMilli());
                }
                preparedStatement.setTimestamp(index, timestamp);
                return;
            }
            case "ArrayValue": {
                Object[] arrayData = Utils.getArrayData(value);
                if (arrayData[0] != null) {
                    Array array = connection.createArrayOf((String)arrayData[1], (Object[])arrayData[0]);
                    preparedStatement.setArray(index, array);
                    return;
                }
                preparedStatement.setArray(index, null);
                return;
            }
            case "RefValue": 
            case "StructValue": {
                Object[] structData = Utils.getStructData(value, connection);
                Object[] dataArray = (Object[])structData[0];
                String structuredSQLType = (String)structData[1];
                if (dataArray == null) {
                    preparedStatement.setNull(index, 2002);
                    return;
                }
                Struct struct = connection.createStruct(structuredSQLType, dataArray);
                preparedStatement.setObject(index, struct);
                return;
            }
            case "RowValue": {
                if (value == null) {
                    preparedStatement.setRowId(index, null);
                    return;
                }
                if (!(value instanceof ArrayValue)) throw Utils.throwInvalidParameterError(value, sqlType);
                ArrayValue arrayValue = (ArrayValue)value;
                if (arrayValue.getElementType().getTag() != 2) throw Utils.throwInvalidParameterError(value, sqlType);
                RowId rowId = () -> ((ArrayValue)arrayValue).getBytes();
                preparedStatement.setRowId(index, rowId);
                return;
            }
            default: {
                throw new ApplicationError("Unsupported SQL type: " + sqlType);
            }
        }
    }

    private static Object[] getArrayData(Object value) throws ApplicationError {
        BType type = TypeChecker.getType((Object)value);
        if (value == null || type.getTag() != 20) {
            return new Object[]{null, null};
        }
        BType elementType = ((BArrayType)type).getElementType();
        int typeTag = elementType.getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = ((ArrayValue)value).size();
                Long[] arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getInt((long)i);
                }
                return new Object[]{arrayData, "BIGINT"};
            }
            case 3: {
                int arrayLength = ((ArrayValue)value).size();
                Double[] arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getFloat((long)i);
                }
                return new Object[]{arrayData, "DOUBLE"};
            }
            case 4: {
                int arrayLength = ((ArrayValue)value).size();
                BigDecimal[] arrayData = new BigDecimal[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((DecimalValue)((ArrayValue)value).getRefValue((long)i)).value();
                }
                return new Object[]{arrayData, "DECIMAL"};
            }
            case 5: {
                int arrayLength = ((ArrayValue)value).size();
                String[] arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getString((long)i);
                }
                return new Object[]{arrayData, "VARCHAR"};
            }
            case 6: {
                int arrayLength = ((ArrayValue)value).size();
                Boolean[] arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((ArrayValue)value).getBoolean((long)i);
                }
                return new Object[]{arrayData, "BOOLEAN"};
            }
            case 20: {
                BType elementTypeOfArrayElement = ((BArrayType)elementType).getElementType();
                if (elementTypeOfArrayElement.getTag() == 2) {
                    ArrayValue arrayValue = (ArrayValue)value;
                    byte[][] arrayData = new byte[arrayValue.size()][];
                    for (int i = 0; i < arrayData.length; ++i) {
                        arrayData[i] = ((ArrayValue)arrayValue.get((long)i)).getBytes();
                    }
                    return new Object[]{arrayData, "BINARY"};
                }
                throw Utils.throwInvalidParameterError(value, "ArrayValue");
            }
        }
        throw Utils.throwInvalidParameterError(value, "ArrayValue");
    }

    private static Object[] getStructData(Object value, Connection conn) throws SQLException, ApplicationError {
        BType type = TypeChecker.getType((Object)value);
        if (value == null || type.getTag() != 35 && type.getTag() != 12) {
            return new Object[]{null, null};
        }
        String structuredSQLType = type.getName().toUpperCase(Locale.getDefault());
        Map structFields = ((BStructureType)type).getFields();
        int fieldCount = structFields.size();
        Object[] structData = new Object[fieldCount];
        Iterator fieldIterator = structFields.values().iterator();
        block5: for (int i = 0; i < fieldCount; ++i) {
            BField field = (BField)fieldIterator.next();
            Object bValue = ((MapValue)value).get((Object)StringUtils.fromString((String)field.getFieldName()));
            int typeTag = field.getFieldType().getTag();
            switch (typeTag) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    structData[i] = bValue;
                    continue block5;
                }
                case 20: {
                    BType elementType = ((BArrayType)field.getFieldType()).getElementType();
                    if (elementType.getTag() == 2) {
                        structData[i] = ((ArrayValue)bValue).getBytes();
                        continue block5;
                    }
                    throw new ApplicationError("unsupported data type of " + structuredSQLType + " specified for struct parameter");
                }
                case 12: {
                    Object structValue = bValue;
                    Object[] internalStructData = Utils.getStructData(structValue, conn);
                    Object[] dataArray = (Object[])internalStructData[0];
                    String internalStructType = (String)internalStructData[1];
                    structData[i] = structValue = conn.createStruct(internalStructType, dataArray);
                    continue block5;
                }
                default: {
                    throw new ApplicationError("unsupported data type of " + structuredSQLType + " specified for struct parameter");
                }
            }
        }
        return new Object[]{structData, structuredSQLType};
    }

    private static ApplicationError throwInvalidParameterError(Object value, String sqlType) {
        String valueName = value instanceof BValue ? ((BValue)value).getType().getName() : value.getClass().getName();
        return new ApplicationError("Invalid parameter :" + valueName + " is passed as value for sql type : " + sqlType);
    }

    static ArrayValue convert(Array array, int sqlType, BType bType) throws SQLException, ApplicationError {
        if (array != null) {
            Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Array");
            Object[] dataArray = (Object[])array.getArray();
            if (dataArray == null || dataArray.length == 0) {
                return null;
            }
            Object[] result = Utils.validateNullable(dataArray);
            Object firstNonNullElement = result[0];
            boolean containsNull = (Boolean)result[1];
            if (containsNull) {
                return Utils.createAndPopulateRefValueArray(firstNonNullElement, dataArray, bType);
            }
            return Utils.createAndPopulatePrimitiveValueArray(firstNonNullElement, dataArray);
        }
        return null;
    }

    private static ArrayValue createAndPopulatePrimitiveValueArray(Object firstNonNullElement, Object[] dataArray) {
        int length = dataArray.length;
        if (firstNonNullElement instanceof String) {
            ArrayValue stringDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)stringArrayType);
            for (int i = 0; i < length; ++i) {
                stringDataArray.add((long)i, (String)dataArray[i]);
            }
            return stringDataArray;
        }
        if (firstNonNullElement instanceof Boolean) {
            ArrayValue boolDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)booleanArrayType);
            for (int i = 0; i < length; ++i) {
                boolDataArray.add((long)i, ((Boolean)dataArray[i]).booleanValue());
            }
            return boolDataArray;
        }
        if (firstNonNullElement instanceof Integer) {
            ArrayValue intDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)intArrayType);
            for (int i = 0; i < length; ++i) {
                intDataArray.add((long)i, (long)((Integer)dataArray[i]).intValue());
            }
            return intDataArray;
        }
        if (firstNonNullElement instanceof Long) {
            ArrayValue longDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)intArrayType);
            for (int i = 0; i < length; ++i) {
                longDataArray.add((long)i, ((Long)dataArray[i]).longValue());
            }
            return longDataArray;
        }
        if (firstNonNullElement instanceof Float) {
            ArrayValue floatDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)floatArrayType);
            for (int i = 0; i < length; ++i) {
                floatDataArray.add((long)i, (double)((Float)dataArray[i]).floatValue());
            }
            return floatDataArray;
        }
        if (firstNonNullElement instanceof Double) {
            ArrayValue doubleDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)floatArrayType);
            for (int i = 0; i < dataArray.length; ++i) {
                doubleDataArray.add((long)i, ((Double)dataArray[i]).doubleValue());
            }
            return doubleDataArray;
        }
        if (firstNonNullElement instanceof BigDecimal) {
            ArrayValue decimalDataArray = (ArrayValue)BValueCreator.createArrayValue((BArrayType)decimalArrayType);
            for (int i = 0; i < dataArray.length; ++i) {
                decimalDataArray.add((long)i, (Object)new DecimalValue((BigDecimal)dataArray[i]));
            }
            return decimalDataArray;
        }
        return null;
    }

    static String getString(Clob data) throws IOException, SQLException {
        if (data == null) {
            return null;
        }
        try (BufferedReader r = new BufferedReader(data.getCharacterStream());){
            int pos;
            StringBuilder sb = new StringBuilder();
            while ((pos = ((Reader)r).read()) != -1) {
                sb.append((char)pos);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static ArrayValue createAndPopulateRefValueArray(Object firstNonNullElement, Object[] dataArray, BType bType) {
        ArrayValue refValueArray;
        block9: {
            int length;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        refValueArray = null;
                                        length = dataArray.length;
                                        if (!(firstNonNullElement instanceof String)) break block8;
                                        refValueArray = Utils.createEmptyRefValueArray(BTypes.typeString);
                                        for (int i = 0; i < length; ++i) {
                                            refValueArray.add((long)i, dataArray[i]);
                                        }
                                        break block9;
                                    }
                                    if (!(firstNonNullElement instanceof Boolean)) break block10;
                                    refValueArray = Utils.createEmptyRefValueArray(BTypes.typeBoolean);
                                    for (int i = 0; i < length; ++i) {
                                        refValueArray.add((long)i, dataArray[i]);
                                    }
                                    break block9;
                                }
                                if (!(firstNonNullElement instanceof Integer)) break block11;
                                refValueArray = Utils.createEmptyRefValueArray(BTypes.typeInt);
                                for (int i = 0; i < length; ++i) {
                                    refValueArray.add((long)i, dataArray[i]);
                                }
                                break block9;
                            }
                            if (!(firstNonNullElement instanceof Long)) break block12;
                            refValueArray = Utils.createEmptyRefValueArray(BTypes.typeInt);
                            for (int i = 0; i < length; ++i) {
                                refValueArray.add((long)i, dataArray[i]);
                            }
                            break block9;
                        }
                        if (!(firstNonNullElement instanceof Float)) break block13;
                        refValueArray = Utils.createEmptyRefValueArray(BTypes.typeFloat);
                        for (int i = 0; i < length; ++i) {
                            refValueArray.add((long)i, dataArray[i]);
                        }
                        break block9;
                    }
                    if (!(firstNonNullElement instanceof Double)) break block14;
                    refValueArray = Utils.createEmptyRefValueArray(BTypes.typeFloat);
                    for (int i = 0; i < length; ++i) {
                        refValueArray.add((long)i, dataArray[i]);
                    }
                    break block9;
                }
                if (!(firstNonNullElement instanceof BigDecimal)) break block15;
                refValueArray = Utils.createEmptyRefValueArray(BTypes.typeDecimal);
                for (int i = 0; i < length; ++i) {
                    refValueArray.add((long)i, (Object)(dataArray[i] != null ? new DecimalValue((BigDecimal)dataArray[i]) : null));
                }
                break block9;
            }
            if (firstNonNullElement != null) break block9;
            refValueArray = Utils.createEmptyRefValueArray(bType);
            for (int i = 0; i < length; ++i) {
                refValueArray.add((long)i, firstNonNullElement);
            }
        }
        return refValueArray;
    }

    private static ArrayValue createEmptyRefValueArray(BType type) {
        ArrayList<BType> memberTypes = new ArrayList<BType>(2);
        memberTypes.add(type);
        memberTypes.add(BTypes.typeNull);
        BUnionType unionType = new BUnionType(memberTypes);
        return (ArrayValue)BValueCreator.createArrayValue((BArrayType)new BArrayType((BType)unionType));
    }

    private static Object[] validateNullable(Object[] objects) {
        Object[] returnResult = new Object[2];
        boolean foundNull = false;
        Object nonNullObject = null;
        for (Object object : objects) {
            if (object != null) {
                if (nonNullObject == null) {
                    nonNullObject = object;
                }
                if (!foundNull) continue;
                break;
            }
            foundNull = true;
            if (nonNullObject != null) break;
        }
        returnResult[0] = nonNullObject;
        returnResult[1] = foundNull;
        return returnResult;
    }

    static BString convert(String value, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL String");
        return StringUtils.fromString((String)value);
    }

    static Object convert(String value, int sqlType, BType bType, String sqlTypeName) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, sqlTypeName);
        return StringUtils.fromString((String)value);
    }

    static Object convert(byte[] value, int sqlType, BType bType, String sqlTypeName) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, sqlTypeName);
        if (value != null) {
            return BValueCreator.createArrayValue((byte[])value);
        }
        return null;
    }

    static Object convert(long value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL long or integer");
        if (isNull) {
            return null;
        }
        if (bType.getTag() == 5) {
            return String.valueOf(value);
        }
        return value;
    }

    static Object convert(double value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL double or float");
        if (isNull) {
            return null;
        }
        if (bType.getTag() == 5) {
            return String.valueOf(value);
        }
        return value;
    }

    static Object convert(BigDecimal value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL decimal or real");
        if (isNull) {
            return null;
        }
        if (bType.getTag() == 5) {
            return String.valueOf(value);
        }
        return new DecimalValue(value);
    }

    static Object convert(Blob value, int sqlType, BType bType) throws ApplicationError, SQLException {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Blob");
        if (value != null) {
            return BValueCreator.createArrayValue((byte[])value.getBytes(1L, (int)value.length()));
        }
        return null;
    }

    static Object convert(java.util.Date date, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Date/Time");
        if (date != null) {
            switch (bType.getTag()) {
                case 5: {
                    return Utils.getString(date);
                }
                case 12: 
                case 35: {
                    return Utils.createTimeStruct(date.getTime());
                }
                case 1: {
                    return date.getTime();
                }
            }
        }
        return null;
    }

    static Object convert(boolean value, int sqlType, BType bType, boolean isNull) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Boolean");
        if (!isNull) {
            switch (bType.getTag()) {
                case 6: {
                    return value;
                }
                case 1: {
                    if (value) {
                        return 1L;
                    }
                    return 0L;
                }
                case 5: {
                    return String.valueOf(value);
                }
            }
        }
        return null;
    }

    static Object convert(Struct value, int sqlType, BType bType) throws ApplicationError {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL Struct");
        if (value != null) {
            if (bType instanceof BRecordType) {
                return Utils.createUserDefinedType(value, (BStructureType)((BRecordType)bType));
            }
            throw new ApplicationError("The ballerina type that can be used for SQL struct should be record type, but found " + bType.getName() + " .");
        }
        return null;
    }

    static Object convert(SQLXML value, int sqlType, BType bType) throws ApplicationError, SQLException {
        Utils.validatedInvalidFieldAssignment(sqlType, bType, "SQL XML");
        if (value != null) {
            if (bType instanceof BXMLType) {
                return XMLFactory.parse((InputStream)value.getBinaryStream());
            }
            throw new ApplicationError("The ballerina type that can be used for SQL struct should be record type, but found " + bType.getName() + " .");
        }
        return null;
    }

    private static MapValue<BString, Object> createUserDefinedType(Struct structValue, BStructureType structType) throws ApplicationError {
        if (structValue == null) {
            return null;
        }
        BField[] internalStructFields = structType.getFields().values().toArray(new BField[0]);
        MapValueImpl struct = new MapValueImpl((BType)structType);
        try {
            Object[] dataArray = structValue.getAttributes();
            if (dataArray != null) {
                if (dataArray.length != internalStructFields.length) {
                    throw new ApplicationError("specified record and the returned SQL Struct field counts are different, and hence not compatible");
                }
                int index = 0;
                for (BField internalField : internalStructFields) {
                    int type = internalField.getFieldType().getTag();
                    BString fieldName = StringUtils.fromString((String)internalField.getFieldName());
                    Object value = dataArray[index];
                    switch (type) {
                        case 1: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (Object)((BigDecimal)value).intValue());
                                break;
                            }
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 3: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, (Object)((BigDecimal)value).doubleValue());
                                break;
                            }
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 4: {
                            if (value instanceof BigDecimal) {
                                struct.put((Object)fieldName, value);
                                break;
                            }
                            struct.put((Object)fieldName, (Object)new DecimalValue((BigDecimal)value));
                            break;
                        }
                        case 5: {
                            struct.put((Object)fieldName, value);
                            break;
                        }
                        case 6: {
                            struct.put((Object)fieldName, (Object)((Integer)value == 1 ? 1 : 0));
                            break;
                        }
                        case 12: 
                        case 35: {
                            struct.put((Object)fieldName, Utils.createUserDefinedType((Struct)value, (BStructureType)internalField.getFieldType()));
                            break;
                        }
                        default: {
                            throw new ApplicationError("Error while retrieving data for unsupported type " + internalField.getFieldType().getName() + " to create " + structType.getName() + " record.");
                        }
                    }
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            throw new ApplicationError("Error while retrieving data to create " + structType.getName() + " record. ", e);
        }
        return struct;
    }

    private static MapValue<BString, Object> createTimeStruct(long millis) {
        return TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)millis, (BString)Constants.TIMEZONE_UTC);
    }

    private static String getString(java.util.Date value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(value);
        if (!calendar.isSet(15)) {
            calendar.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer datetimeString = new StringBuffer(28);
        if (value instanceof Date) {
            calendar.setTime(value);
            Utils.appendDate(datetimeString, calendar);
            Utils.appendTimeZone(calendar, datetimeString);
        } else if (value instanceof Time) {
            calendar.setTimeInMillis(value.getTime());
            Utils.appendTime(calendar, datetimeString);
            Utils.appendTimeZone(calendar, datetimeString);
        } else if (value instanceof Timestamp) {
            calendar.setTimeInMillis(value.getTime());
            Utils.appendDate(datetimeString, calendar);
            datetimeString.append("T");
            Utils.appendTime(calendar, datetimeString);
            Utils.appendTimeZone(calendar, datetimeString);
        } else {
            calendar.setTime(value);
            Utils.appendTime(calendar, datetimeString);
            Utils.appendTimeZone(calendar, datetimeString);
        }
        return datetimeString.toString();
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    private static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    private static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }

    private static void validatedInvalidFieldAssignment(int sqlType, BType bType, String sqlTypeName) throws ApplicationError {
        if (!Utils.isValidFieldConstraint(sqlType, bType)) {
            throw new ApplicationError(sqlTypeName + " field cannot be converted to ballerina type : " + bType.getName());
        }
    }

    static BType validFieldConstraint(int sqlType, BType bType) {
        if (bType.getTag() == 21 && bType instanceof BUnionType) {
            BUnionType bUnionType = (BUnionType)bType;
            for (BType memberType : bUnionType.getMemberTypes()) {
                if (!Utils.isValidFieldConstraint(sqlType, memberType)) continue;
                return memberType;
            }
        } else if (Utils.isValidPrimitiveConstraint(sqlType, bType)) {
            return bType;
        }
        return null;
    }

    public static boolean isValidFieldConstraint(int sqlType, BType bType) {
        if (bType.getTag() == 21 && bType instanceof BUnionType) {
            BUnionType bUnionType = (BUnionType)bType;
            for (BType memberType : bUnionType.getMemberTypes()) {
                if (!Utils.isValidFieldConstraint(sqlType, memberType)) continue;
                return true;
            }
            return false;
        }
        return Utils.isValidPrimitiveConstraint(sqlType, bType);
    }

    private static boolean isValidPrimitiveConstraint(int sqlType, BType bType) {
        switch (sqlType) {
            case 2003: {
                return bType.getTag() == 20;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return bType.getTag() == 5 || bType.getTag() == 7;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return bType.getTag() == 5 || bType.getTag() == 35 || bType.getTag() == 12 || bType.getTag() == 1;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return bType.getTag() == 1 || bType.getTag() == 5;
            }
            case -7: 
            case 16: {
                return bType.getTag() == 6 || bType.getTag() == 1 || bType.getTag() == 5;
            }
            case 2: 
            case 3: {
                return bType.getTag() == 4 || bType.getTag() == 1 || bType.getTag() == 5;
            }
            case 6: 
            case 7: 
            case 8: {
                return bType.getTag() == 3 || bType.getTag() == 5;
            }
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (bType.getTag() == 20) {
                    int elementTypeTag = ((BArrayType)bType).getElementType().getTag();
                    return elementTypeTag == 2;
                }
                return bType.getTag() == 5 || bType.getTag() == 36;
            }
            case 2002: 
            case 2006: {
                return bType.getTag() == 12;
            }
            case 2009: {
                return bType.getTag() == 8;
            }
        }
        return bType.getTag() == 17 || bType.getTag() == 11 || bType.getTag() == 20 && ((BArrayType)bType).getElementType().getTag() == 2 || bType.getTag() == 5 || bType.getTag() == 1 || bType.getTag() == 6 || bType.getTag() == 8 || bType.getTag() == 3 || bType.getTag() == 4 || bType.getTag() == 7;
    }
}

