/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import org.ballerinalang.tool.util.CompileResult;
import org.testng.Assert;

public class BAssertUtil {
    private static final String CARRIAGE_RETURN_CHAR = "\\r";
    private static final String EMPTY_STRING = "";

    public static void validateError(CompileResult result, int errorIndex, String expectedErrMsg, int expectedErrLine, int expectedErrCol) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, (String)"incorrect diagnostic type");
        Assert.assertEquals((String)diag.message().replace(CARRIAGE_RETURN_CHAR, EMPTY_STRING), (String)expectedErrMsg.replace(CARRIAGE_RETURN_CHAR, EMPTY_STRING), (String)"incorrect error message:");
        Assert.assertEquals((int)(diag.location().lineRange().startLine().line() + 1), (int)expectedErrLine, (String)"incorrect line number:");
        Assert.assertEquals((int)(diag.location().lineRange().startLine().offset() + 1), (int)expectedErrCol, (String)"incorrect column position:");
    }

    public static void validateError(CompileResult result, int errorIndex, int expectedErrLine, int expectedErrCol) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, (String)"incorrect diagnostic type");
        Assert.assertEquals((int)(diag.location().lineRange().startLine().line() + 1), (int)expectedErrLine, (String)"incorrect line number:");
        Assert.assertEquals((int)(diag.location().lineRange().startLine().offset() + 1), (int)expectedErrCol, (String)"incorrect column position:");
    }

    public static void validateErrorMessageOnly(CompileResult result, int errorIndex, String expectedPartOfErrMsg) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, (String)"incorrect diagnostic type");
        Assert.assertTrue((boolean)diag.message().contains(expectedPartOfErrMsg), (String)("'" + expectedPartOfErrMsg + "' is not contained in error message '" + diag.message() + "'"));
    }

    public static void validateErrorMessageOnly(CompileResult result, int errorIndex, String[] expectedPartsOfErrMsg) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, (String)"incorrect diagnostic type");
        boolean contains = false;
        for (String part : expectedPartsOfErrMsg) {
            if (!diag.message().contains(part)) continue;
            contains = true;
            break;
        }
        Assert.assertTrue((boolean)contains, (String)("None of given strings is contained in the error message '" + diag.message() + "'"));
    }

    public static void validateWarning(CompileResult result, int warningIndex, String expectedWarnMsg, int expectedWarnLine, int expectedWarnCol) {
        Diagnostic diag = result.getDiagnostics()[warningIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.WARNING, (String)"incorrect diagnostic type");
        Assert.assertEquals((String)diag.message(), (String)expectedWarnMsg, (String)"incorrect warning message:");
        Assert.assertEquals((int)(diag.location().lineRange().startLine().line() + 1), (int)expectedWarnLine, (String)"incorrect line number:");
        Assert.assertEquals((int)(diag.location().lineRange().startLine().offset() + 1), (int)expectedWarnCol, (String)"incorrect column position:");
    }
}

