/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.tree.PackageNode;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.diagnostic.DiagnosticComparator;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CompileResult {
    private PackageNode pkgNode;
    private CompilerContext context;
    private Diagnostic[] diagnostics = null;
    private int errorCount = 0;
    private int warnCount = 0;

    public CompileResult(CompilerContext context, BLangPackage packageNode) {
        this.pkgNode = packageNode;
        this.context = context;
    }

    public Diagnostic[] getDiagnostics() {
        if (this.diagnostics == null) {
            this.populateDiagnostics();
        }
        return this.diagnostics;
    }

    public int getErrorCount() {
        if (this.diagnostics == null) {
            this.populateDiagnostics();
        }
        return this.errorCount;
    }

    public int getWarnCount() {
        if (this.diagnostics == null) {
            this.populateDiagnostics();
        }
        return this.warnCount;
    }

    public PackageNode getAST() {
        return this.pkgNode;
    }

    public void setAST(PackageNode pkgNode) {
        this.pkgNode = pkgNode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getErrorCount() == 0) {
            builder.append("Compilation Successful");
        } else {
            builder.append("Compilation Failed:\n");
            for (Diagnostic diag : this.getDiagnostics()) {
                builder.append(diag + "\n");
            }
        }
        return builder.toString();
    }

    private void populateDiagnostics() {
        BLangPackage bLangPkg = (BLangPackage)this.pkgNode;
        this.errorCount = bLangPkg.getErrorCount();
        this.warnCount = bLangPkg.getWarnCount();
        List diagList = bLangPkg.getDiagnostics();
        PackageCache packageCache = PackageCache.getInstance((CompilerContext)this.context);
        for (BLangImportPackage importedPackage : bLangPkg.getImports()) {
            BLangPackage pkg;
            BPackageSymbol pkgSymbol = importedPackage.symbol;
            if (pkgSymbol == null || (pkg = packageCache.get(pkgSymbol.pkgID)) == null) continue;
            diagList.addAll(pkg.getDiagnostics());
            this.errorCount += pkg.getErrorCount();
            this.warnCount += pkg.getWarnCount();
        }
        Collections.sort(diagList, new DiagnosticComparator());
        this.diagnostics = diagList.toArray(new Diagnostic[diagList.size()]);
    }
}

