/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.websub.WebSubHttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSubServicesRegistry
extends HTTPServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(WebSubServicesRegistry.class);
    private String topicIdentifier;
    private String topicHeader;
    private MapValue<String, Object> headerResourceMap;
    private MapValue<String, MapValue<String, Object>> payloadKeyResourceMap;
    private MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap;
    private HashMap<String, BRecordType> resourceDetails;
    private static final int CUSTOM_RESOURCE_PARAM_COUNT = 2;

    public WebSubServicesRegistry(WebSocketServicesRegistry webSocketServicesRegistry) {
        super(webSocketServicesRegistry);
    }

    public WebSubServicesRegistry(WebSocketServicesRegistry webSocketServicesRegistry, String topicIdentifier, String topicHeader, MapValue<String, Object> headerResourceMap, MapValue<String, MapValue<String, Object>> payloadKeyResourceMap, MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap, HashMap<String, BRecordType> resourceDetails) {
        super(webSocketServicesRegistry);
        this.topicIdentifier = topicIdentifier;
        this.topicHeader = topicHeader;
        this.headerResourceMap = headerResourceMap;
        this.payloadKeyResourceMap = payloadKeyResourceMap;
        this.headerAndPayloadKeyResourceMap = headerAndPayloadKeyResourceMap;
        this.resourceDetails = resourceDetails;
    }

    String getTopicIdentifier() {
        return this.topicIdentifier;
    }

    String getTopicHeader() {
        return this.topicHeader;
    }

    MapValue<String, Object> getHeaderResourceMap() {
        return this.headerResourceMap;
    }

    MapValue<String, MapValue<String, Object>> getPayloadKeyResourceMap() {
        return this.payloadKeyResourceMap;
    }

    MapValue<String, MapValue<String, MapValue<String, Object>>> getHeaderAndPayloadKeyResourceMap() {
        return this.headerAndPayloadKeyResourceMap;
    }

    HashMap<String, BRecordType> getResourceDetails() {
        return this.resourceDetails;
    }

    public void registerWebSubSubscriberService(ObjectValue service) {
        WebSubHttpService httpService = WebSubHttpService.buildWebSubSubscriberHttpService(service);
        String hostName = httpService.getHostName();
        if (this.servicesMapByHost.get(hostName) == null) {
            this.servicesByBasePath = new ConcurrentHashMap();
            this.sortedServiceURIs = new CopyOnWriteArrayList();
            this.servicesMapByHost.put(hostName, new HTTPServicesRegistry.ServicesMapHolder((HTTPServicesRegistry)this, this.servicesByBasePath, this.sortedServiceURIs));
        } else {
            this.servicesByBasePath = this.getServicesByHost(hostName);
            this.sortedServiceURIs = this.getSortedServiceURIsByHost(hostName);
        }
        this.servicesByBasePath.put(httpService.getBasePath(), httpService);
        logger.info("Service deployed : " + service.getType().getName() + " with context " + httpService.getBasePath());
        this.sortedServiceURIs.add(httpService.getBasePath());
        this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
        if (this.topicIdentifier != null) {
            WebSubServicesRegistry.validateCustomResources(httpService.getResources(), this);
        }
    }

    private static void validateCustomResources(List<HttpResource> resources, WebSubServicesRegistry serviceRegistry) {
        List<String> invalidResourceNames = WebSubServicesRegistry.retrieveInvalidResourceNames(resources, serviceRegistry.getResourceDetails());
        if (!invalidResourceNames.isEmpty()) {
            throw BallerinaErrors.createError((String)("Resource name(s) not included in the topic-resource mapping found: " + invalidResourceNames));
        }
    }

    private static List<String> retrieveInvalidResourceNames(List<HttpResource> resources, HashMap<String, BRecordType> resourceDetails) {
        Set<String> resourceNames = resourceDetails.keySet();
        ArrayList<String> invalidResourceNames = new ArrayList<String>();
        for (HttpResource resource : resources) {
            String resourceName = resource.getName();
            if ("onIntentVerification".equals(resourceName)) {
                WebSubServicesRegistry.validateOnIntentVerificationResource(resource);
                continue;
            }
            if (!resourceNames.contains(resourceName)) {
                invalidResourceNames.add(resourceName);
                continue;
            }
            WebSubServicesRegistry.validateCustomNotificationResource(resource, resourceDetails.get(resourceName));
        }
        return invalidResourceNames;
    }

    private static void validateOnIntentVerificationResource(HttpResource resource) {
        List paramTypes = resource.getParamTypes();
        WebSubServicesRegistry.validateParamCount(paramTypes, 2, resource.getName());
        WebSubServicesRegistry.validateCallerParam((BType)paramTypes.get(0));
        WebSubServicesRegistry.validateIntentVerificationParam((BType)paramTypes.get(1));
    }

    private static void validateCustomNotificationResource(HttpResource resource, BRecordType recordType) {
        List paramTypes = resource.getParamTypes();
        WebSubServicesRegistry.validateParamCount(paramTypes, 2, resource.getName());
        WebSubServicesRegistry.validateNotificationParam(resource.getName(), (BType)paramTypes.get(0));
        WebSubServicesRegistry.validateRecordType(resource.getName(), (BType)paramTypes.get(1), recordType);
    }

    private static void validateParamCount(List<BType> paramTypes, int expectedCount, String resourceName) {
        int paramCount = paramTypes.size();
        if (paramCount < expectedCount) {
            throw BallerinaErrors.createError((String)String.format("Invalid param count for WebSub Resource '%s': expected '%d', found '%d'", resourceName, expectedCount, paramCount));
        }
    }

    private static void validateCallerParam(BType paramVarType) {
        if (!WebSubServicesRegistry.isExpectedObjectParam(paramVarType, "Caller")) {
            throw BallerinaErrors.createError((String)String.format("Invalid parameter type '%s' in resource '%s'. Requires '%s:%s'", paramVarType.getQualifiedName(), "onIntentVerification", "ballerina/websub", "Caller"));
        }
    }

    private static void validateIntentVerificationParam(BType paramVarType) {
        if (!WebSubServicesRegistry.isExpectedObjectParam(paramVarType, "IntentVerificationRequest")) {
            throw BallerinaErrors.createError((String)String.format("Invalid parameter type '%s' in resource '%s'. Requires '%s:%s'", paramVarType.getQualifiedName(), "onIntentVerification", "ballerina/websub", "IntentVerificationRequest"));
        }
    }

    private static void validateNotificationParam(String resourceName, BType paramVarType) {
        if (!WebSubServicesRegistry.isExpectedObjectParam(paramVarType, "Notification")) {
            throw BallerinaErrors.createError((String)String.format("Invalid parameter type '%s' in resource '%s'. Requires '%s:%s'", paramVarType.getQualifiedName(), resourceName, "ballerina/websub", "Notification"));
        }
    }

    private static void validateRecordType(String resourceName, BType paramVarType, BRecordType recordType) {
        if (!TypeChecker.isSameType((BType)paramVarType, (BType)recordType)) {
            throw BallerinaErrors.createError((String)String.format("Invalid parameter type '%s' in resource '%s'. Requires '%s'", paramVarType.getQualifiedName(), resourceName, recordType.getQualifiedName()));
        }
    }

    private static boolean isExpectedObjectParam(BType specifiedType, String expectedWebSubRecordName) {
        if (specifiedType.getTag() != 35) {
            return false;
        }
        BObjectType objectType = (BObjectType)specifiedType;
        return objectType.getPackage().org.equals("ballerina") && objectType.getPackage().name.equals("websub") && objectType.getName().equals(expectedWebSubRecordName);
    }
}

