/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class WebSubUtils {
    public static final String WEBSUB_ERROR_CODE = "{ballerina/websub}WebSubError";

    static ObjectValue getHttpRequest(HttpCarbonMessage httpCarbonMessage) {
        ObjectValue httpRequest = BallerinaValues.createObjectValue((String)"ballerina/http", (String)"Request", (Object[])new Object[0]);
        ObjectValue inRequestEntity = BallerinaValues.createObjectValue((String)"ballerina/mime", (String)"Entity", (Object[])new Object[0]);
        HttpUtil.populateInboundRequest((ObjectValue)httpRequest, (ObjectValue)inRequestEntity, (HttpCarbonMessage)httpCarbonMessage);
        HttpUtil.populateEntityBody((ObjectValue)httpRequest, (ObjectValue)inRequestEntity, (boolean)true, (boolean)true);
        return httpRequest;
    }

    static MapValue<String, ?> getJsonBody(ObjectValue httpRequest) {
        ObjectValue entityObj = HttpUtil.extractEntity((ObjectValue)httpRequest);
        if (entityObj != null) {
            String stringPayload;
            Object dataSource = EntityBodyHandler.getMessageDataSource((ObjectValue)entityObj);
            if (dataSource != null) {
                stringPayload = MimeUtil.getMessageAsString((Object)dataSource);
            } else {
                stringPayload = EntityBodyHandler.constructStringDataSource((ObjectValue)entityObj);
                EntityBodyHandler.addMessageDataSource((ObjectValue)entityObj, (Object)stringPayload);
                entityObj.addNativeData("entity_byte_channel", null);
            }
            Object result = JSONParser.parse((String)stringPayload);
            if (result instanceof MapValue) {
                return (MapValue)result;
            }
            throw new BallerinaConnectorException("Non-compatible payload received for payload key based dispatching");
        }
        throw new BallerinaConnectorException("Error retrieving payload for payload key based dispatching");
    }

    public static AttachedFunction getAttachedFunction(ObjectValue service, String functionName) {
        AttachedFunction attachedFunction = null;
        String functionFullName = service.getType().getName() + "." + functionName;
        for (AttachedFunction function : service.getType().getAttachedFunctions()) {
            if (!functionFullName.contains(function.getName())) continue;
            attachedFunction = function;
        }
        return attachedFunction;
    }

    public static ErrorValue createError(String errMsg) {
        return BallerinaErrors.createError((String)WEBSUB_ERROR_CODE, (String)errMsg);
    }
}

