/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.compiler;

import java.util.List;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.net.websub.WebSubSubscriberServiceValidator;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.util.AbstractTransportCompilerPlugin;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="websub", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="websub", name="Caller"), @SupportedResourceParamTypes.Type(packageName="websub", name="IntentVerificationRequest"), @SupportedResourceParamTypes.Type(packageName="websub", name="Notification")})
public class WebSubServiceCompilerPlugin
extends AbstractTransportCompilerPlugin {
    private DiagnosticLog dlog = null;
    private static final String WEBSUB_LISTENER = "T".concat("ballerina/websub").concat(":").concat("Listener").concat(";");

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        int webSubAnnotationConfigCount = 0;
        for (AnnotationAttachmentNode annotation2 : annotations) {
            if (!"SubscriberServiceConfig".equals(annotation2.getAnnotationName().getValue())) continue;
            ++webSubAnnotationConfigCount;
        }
        if (webSubAnnotationConfigCount == 0) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"'SubscriberServiceConfig' annotation is compulsory");
            return;
        }
        BType listenerType = ((BLangService)serviceNode).listenerType;
        if (listenerType == null ? annotations.stream().anyMatch(annotation -> "websub".equals(annotation.getPackageAlias().getValue()) && "SpecificSubscriber".equals(annotation.getAnnotationName().getValue())) : !WEBSUB_LISTENER.equals(listenerType.getDesc())) {
            return;
        }
        List resources = serviceNode.getResources();
        if (resources.size() > 2) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"cannot have more than two resources with ballerina/websub:Service");
            return;
        }
        if (resources.size() < 1 || resources.size() == 1 && !"onNotification".equals(((BLangFunction)resources.get(0)).getName().getValue())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"required resource 'onNotification' not specified with ballerina/websub:Service");
        }
        resources.forEach(res -> WebSubSubscriberServiceValidator.validateDefaultResources(res, this.isResourceReturnsErrorOrNil((FunctionNode)res), this.dlog));
    }
}

